/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.gui;

import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProviderShaderOptions;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionProfile;
import net.optifine.shaders.config.ShaderOptionScreen;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.shaders.gui.GuiSliderShaderOption;

public class GuiShaderOptions
extends GuiScreenOF {
    private dgb prevScreen;
    private dbr settings;
    private TooltipManager tooltipManager = new TooltipManager(this, new TooltipProviderShaderOptions());
    private String screenName = null;
    private String screenText = null;
    private boolean changed = false;
    public static final String OPTION_PROFILE = "<profile>";
    public static final String OPTION_EMPTY = "<empty>";
    public static final String OPTION_REST = "*";

    public GuiShaderOptions(dgb guiscreen, dbr gamesettings) {
        super((lf)new lo(ebd.a((String)"of.options.shaderOptionsTitle", (Object[])new Object[0])));
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    public GuiShaderOptions(dgb guiscreen, dbr gamesettings, String screenName) {
        this(guiscreen, gamesettings);
        this.screenName = screenName;
        if (screenName != null) {
            this.screenText = Shaders.translate("screen." + screenName, screenName);
        }
    }

    public void init() {
        int baseId = 100;
        int baseX = 0;
        int baseY = 30;
        int stepY = 20;
        int btnWidth = 120;
        int btnHeight = 20;
        int columns = Shaders.getShaderPackColumns(this.screenName, 2);
        ShaderOption[] ops = Shaders.getShaderPackOptions(this.screenName);
        if (ops != null) {
            int colsMin = abr.f((double)((double)ops.length / 9.0));
            if (columns < colsMin) {
                columns = colsMin;
            }
            for (int i2 = 0; i2 < ops.length; ++i2) {
                ShaderOption so = ops[i2];
                if (so == null || !so.isVisible()) continue;
                int col = i2 % columns;
                int row = i2 / columns;
                int colWidth = Math.min(this.width / columns, 200);
                baseX = (this.width - colWidth * columns) / 2;
                int x = col * colWidth + 5 + baseX;
                int y = baseY + row * stepY;
                int w = colWidth - 10;
                int h2 = btnHeight;
                String text = GuiShaderOptions.getButtonText(so, w);
                GuiButtonShaderOption btn2 = Shaders.isShaderPackOptionSlider(so.getName()) ? new GuiSliderShaderOption(baseId + i2, x, y, w, h2, so, text) : new GuiButtonShaderOption(baseId + i2, x, y, w, h2, so, text);
                btn2.active = so.isEnabled();
                this.addButton((dct)btn2);
            }
        }
        this.addButton((dct)new GuiButtonOF(201, this.width / 2 - btnWidth - 20, this.height / 6 + 168 + 11, btnWidth, btnHeight, ebd.a((String)"controls.reset", (Object[])new Object[0])));
        this.addButton((dct)new GuiButtonOF(200, this.width / 2 + 20, this.height / 6 + 168 + 11, btnWidth, btnHeight, ebd.a((String)"gui.done", (Object[])new Object[0])));
    }

    public static String getButtonText(ShaderOption so, int btnWidth) {
        String labelName = so.getNameText();
        if (so instanceof ShaderOptionScreen) {
            ShaderOptionScreen soScr = (ShaderOptionScreen)so;
            return labelName + "...";
        }
        dch fr = Config.getMinecraft().f;
        int lenSuffix = fr.b(": " + Lang.getOff()) + 5;
        while (fr.b(labelName) + lenSuffix >= btnWidth && labelName.length() > 0) {
            labelName = labelName.substring(0, labelName.length() - 1);
        }
        String col = so.isChanged() ? so.getValueColor(so.getValue()) : "";
        String labelValue = so.getValueText(so.getValue());
        return labelName + ": " + col + labelValue;
    }

    @Override
    protected void actionPerformed(dct guiElement) {
        if (!(guiElement instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF guibutton = (GuiButtonOF)guiElement;
        if (!guibutton.active) {
            return;
        }
        if (guibutton.id < 200 && guibutton instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guibutton;
            ShaderOption so = btnSo.getShaderOption();
            if (so instanceof ShaderOptionScreen) {
                String screenName = so.getName();
                GuiShaderOptions scr = new GuiShaderOptions(this, this.settings, screenName);
                this.minecraft.a((dgb)scr);
                return;
            }
            if (GuiShaderOptions.hasShiftDown()) {
                so.resetValue();
            } else if (btnSo.isSwitchable()) {
                so.nextValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
        if (guibutton.id == 201) {
            ShaderOption[] opts = Shaders.getChangedOptions(Shaders.getShaderPackOptions());
            for (int i2 = 0; i2 < opts.length; ++i2) {
                ShaderOption opt = opts[i2];
                opt.resetValue();
                this.changed = true;
            }
            this.updateAllButtons();
        }
        if (guibutton.id == 200) {
            if (this.changed) {
                Shaders.saveShaderPackOptions();
                this.changed = false;
                Shaders.uninit();
            }
            this.minecraft.a(this.prevScreen);
        }
    }

    public void removed() {
        if (this.changed) {
            Shaders.saveShaderPackOptions();
            this.changed = false;
            Shaders.uninit();
        }
        super.removed();
    }

    @Override
    protected void actionPerformedRightClick(dct guiElement) {
        if (guiElement instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guiElement;
            ShaderOption so = btnSo.getShaderOption();
            if (GuiShaderOptions.hasShiftDown()) {
                so.resetValue();
            } else if (btnSo.isSwitchable()) {
                so.prevValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
    }

    private void updateAllButtons() {
        for (dcv btn2 : this.buttonList) {
            if (!(btn2 instanceof GuiButtonShaderOption)) continue;
            GuiButtonShaderOption gbso = (GuiButtonShaderOption)btn2;
            ShaderOption opt = gbso.getShaderOption();
            if (opt instanceof ShaderOptionProfile) {
                ShaderOptionProfile optProf = (ShaderOptionProfile)opt;
                optProf.updateProfile();
            }
            gbso.setMessage(GuiShaderOptions.getButtonText(opt, gbso.getWidth()));
            gbso.valueChanged();
        }
    }

    public void render(int x, int y, float f2) {
        this.renderBackground();
        if (this.screenText != null) {
            this.drawCenteredString(this.fontRenderer, this.screenText, this.width / 2, 15, 0xFFFFFF);
        } else {
            this.drawCenteredString(this.fontRenderer, this.title.e(), this.width / 2, 15, 0xFFFFFF);
        }
        super.render(x, y, f2);
        this.tooltipManager.drawTooltips(x, y, this.buttonList);
    }
}

