/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Random;

public class TestMath {
    static Random random = new Random();

    public static void main(String[] args) {
        int count = 1000000;
        TestMath.dbg("Test math: " + count);
        for (int i2 = 0; i2 < 1000000; ++i2) {
            TestMath.testMatrix4f_mulTranslate();
            TestMath.testMatrix4f_mulScale();
            TestMath.testMatrix4f_mulQuaternion();
            TestMath.testMatrix3f_mulQuaternion();
            TestMath.testVector4f_transform();
            TestMath.testVector3f_transform();
        }
        TestMath.dbg("Done");
    }

    private static void testMatrix4f_mulTranslate() {
        b m2 = new b();
        m2.setRandom(random);
        b m22 = m2.d();
        float x = random.nextFloat();
        float y = random.nextFloat();
        float z = random.nextFloat();
        m2.a(b.b((float)x, (float)y, (float)z));
        m22.mulTranslate(x, y, z);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testMatrix4f_mulScale() {
        b m2 = new b();
        m2.setRandom(random);
        b m22 = m2.d();
        float x = random.nextFloat();
        float y = random.nextFloat();
        float z = random.nextFloat();
        m2.a(b.a((float)x, (float)y, (float)z));
        m22.mulScale(x, y, z);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testMatrix4f_mulQuaternion() {
        b m2 = new b();
        m2.setRandom(random);
        b m22 = m2.d();
        c q = new c(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.a(new b(q));
        m22.a(q);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testMatrix3f_mulQuaternion() {
        a m2 = new a();
        m2.setRandom(random);
        a m22 = m2.d();
        c q = new c(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.b(new a(q));
        m22.a(q);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testVector3f_transform() {
        e v = new e(random.nextFloat(), random.nextFloat(), random.nextFloat());
        e v2 = v.e();
        a m2 = new a();
        m2.setRandom(random);
        v.a(m2);
        float x = m2.getTransformX(v2.a(), v2.b(), v2.c());
        float y = m2.getTransformY(v2.a(), v2.b(), v2.c());
        float z = m2.getTransformZ(v2.a(), v2.b(), v2.c());
        v2 = new e(x, y, z);
        if (!v2.equals((Object)v)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(v.toString());
            TestMath.dbg(v2.toString());
        }
    }

    private static void testVector4f_transform() {
        f v = new f(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        f v2 = new f(v.a(), v.b(), v.c(), v.d());
        b m2 = new b();
        m2.setRandom(random);
        v.a(m2);
        float x = m2.getTransformX(v2.a(), v2.b(), v2.c(), v2.d());
        float y = m2.getTransformY(v2.a(), v2.b(), v2.c(), v2.d());
        float z = m2.getTransformZ(v2.a(), v2.b(), v2.c(), v2.d());
        float w = m2.getTransformW(v2.a(), v2.b(), v2.c(), v2.d());
        v2 = new f(x, y, z, w);
        if (!v2.equals((Object)v)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(v.toString());
            TestMath.dbg(v2.toString());
        }
    }

    private static void dbg(String str) {
        System.out.println(str);
    }
}

