/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;

public class ModelUtils {
    private static final Random RANDOM = new Random(0L);

    public static void dbgModel(ebv model) {
        if (model == null) {
            return;
        }
        Config.dbg("Model: " + model + ", ao: " + model.a() + ", gui3d: " + model.b() + ", builtIn: " + model.d() + ", particle: " + model.e());
        fp[] faces = fp.n;
        for (int i2 = 0; i2 < faces.length; ++i2) {
            fp face = faces[i2];
            List faceQuads = model.a(null, face, RANDOM);
            ModelUtils.dbgQuads(face.o(), faceQuads, "  ");
        }
        List generalQuads = model.a(null, null, RANDOM);
        ModelUtils.dbgQuads("General", generalQuads, "  ");
    }

    private static void dbgQuads(String name, List quads, String prefix) {
        for (drn quad : quads) {
            ModelUtils.dbgQuad(name, quad, prefix);
        }
    }

    public static void dbgQuad(String name, drn quad, String prefix) {
        Config.dbg(prefix + "Quad: " + quad.getClass().getName() + ", type: " + name + ", face: " + quad.e() + ", tint: " + quad.d() + ", sprite: " + quad.getSprite());
        ModelUtils.dbgVertexData(quad.b(), "  " + prefix);
    }

    public static void dbgVertexData(int[] vd, String prefix) {
        int step = vd.length / 4;
        Config.dbg(prefix + "Length: " + vd.length + ", step: " + step);
        for (int i2 = 0; i2 < 4; ++i2) {
            int pos = i2 * step;
            float x = Float.intBitsToFloat(vd[pos + 0]);
            float y = Float.intBitsToFloat(vd[pos + 1]);
            float z = Float.intBitsToFloat(vd[pos + 2]);
            int col = vd[pos + 3];
            float u = Float.intBitsToFloat(vd[pos + 4]);
            float v = Float.intBitsToFloat(vd[pos + 5]);
            Config.dbg(prefix + i2 + " xyz: " + x + "," + y + "," + z + " col: " + col + " u,v: " + u + "," + v);
        }
    }

    public static ebv duplicateModel(ebv model) {
        List generalQuads2 = ModelUtils.duplicateQuadList(model.a(null, null, RANDOM));
        fp[] faces = fp.n;
        HashMap<fp, List> faceQuads2 = new HashMap<fp, List>();
        for (int i2 = 0; i2 < faces.length; ++i2) {
            fp face = faces[i2];
            List quads = model.a(null, face, RANDOM);
            List quads2 = ModelUtils.duplicateQuadList(quads);
            faceQuads2.put(face, quads2);
        }
        ece model2 = new ece(generalQuads2, faceQuads2, model.a(), model.b(), true, model.e(), model.f(), model.g());
        return model2;
    }

    public static List duplicateQuadList(List list) {
        ArrayList<drn> list2 = new ArrayList<drn>();
        for (drn quad : list) {
            drn quad2 = ModelUtils.duplicateQuad(quad);
            list2.add(quad2);
        }
        return list2;
    }

    public static drn duplicateQuad(drn quad) {
        drn quad2 = new drn((int[])quad.b().clone(), quad.d(), quad.e(), quad.getSprite());
        return quad2;
    }
}

