/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static ebv makeModelCube(String spriteName, int tintIndex) {
        eaj sprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static ebv makeModelCube(eaj sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        fp[] facings = fp.n;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            fp facing = facings[i2];
            ArrayList<drn> quads = new ArrayList<drn>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        drx itemOverrideList = drx.a;
        ece bakedModel = new ece(generalQuads, faceQuads, true, true, true, sprite, drz.a, itemOverrideList);
        return bakedModel;
    }

    public static ebv joinModelsCube(ebv modelBase, ebv modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        fp[] facings = fp.n;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            fp facing = facings[i2];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.d();
        eaj sprite = modelBase.e();
        drz transforms = modelBase.f();
        drx itemOverrideList = modelBase.g();
        ece bakedModel = new ece(generalQuads, faceQuads, ao, builtIn, true, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static drn makeBakedQuad(fp facing, eaj sprite, int tintIndex) {
        e posFrom = new e(0.0f, 0.0f, 0.0f);
        e posTo = new e(16.0f, 16.0f, 16.0f);
        drr uv = new drr(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        drp face = new drp(facing, tintIndex, "#" + facing.o(), uv);
        ebw modelRotation = ebw.a;
        drq partRotation = null;
        boolean shade = true;
        sm modelLoc = sprite.l();
        dru faceBakery = new dru();
        drn quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (ecc)modelRotation, partRotation, shade, modelLoc);
        return quad;
    }

    public static ebv makeModel(String modelName, String spriteOldName, String spriteNewName) {
        eai textureMap = Config.getTextureMap();
        eaj spriteOld = textureMap.getUploadedSprite(spriteOldName);
        eaj spriteNew = textureMap.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static ebv makeModel(String modelName, eaj spriteOld, eaj spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        eca modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        ecb mrl = new ecb(modelName, "");
        ebv model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        ebv modelNew = ModelUtils.duplicateModel(model);
        fp[] faces = fp.n;
        for (int i2 = 0; i2 < faces.length; ++i2) {
            fp face = faces[i2];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<drn> quads, eaj spriteOld, eaj spriteNew) {
        ArrayList<drn> quadsNew = new ArrayList<drn>();
        for (drn quad : quads) {
            if (quad.getSprite() == spriteOld) {
                quad = new BakedQuadRetextured(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(e pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static cvf getOffsetBoundingBox(cvf aabb, bph.b offsetType, fk pos) {
        int x = pos.o();
        int z = pos.q();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == bph.b.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

