/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<aku, bwm> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(aku entityType, String name, float shadowSize) {
        this(Either.makeLeft(entityType), name, shadowSize, null);
    }

    public ModelAdapter(aku entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft(entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(bwm tileEntityType, String name, float shadowSize) {
        this(Either.makeRight(tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(Either<aku, bwm> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<aku, bwm> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract dls makeModel();

    public abstract dni getModelRenderer(dls var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(dls var1, float var2);

    public dni[] getModelRenderers(dls model) {
        String[] names = this.getModelRendererNames();
        ArrayList<dni> list = new ArrayList<dni>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            dni mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        dni[] mrs = list.toArray(new dni[list.size()]);
        return mrs;
    }
}

