/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.UsernameCache;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    private static DecimalFormat dfCommas = new DecimalFormat("##.##");

    @Override
    public String getID() {
        return "theoneprobe:entity.default";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, Entity entity, IProbeHitEntityData data) {
        IProbeConfig config = Config.getRealConfig();
        boolean handled = false;
        for (IEntityDisplayOverride override : TheOneProbe.theOneProbeImp.getEntityOverrides()) {
            if (!override.overrideStandardInfo(mode, probeInfo, player, world, entity, data)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        }
        if (entity instanceof Mob) {
            Collection effects;
            AgeableMob ageable;
            int age;
            Mob livingBase = (Mob)entity;
            if (Tools.show(mode, config.getShowMobHealth())) {
                int health = (int)livingBase.m_21223_();
                int maxHealth = (int)livingBase.m_21233_();
                int armor = livingBase.m_21230_();
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(CompoundText.createLabelInfo("Health: ", health + " / " + maxHealth));
                }
                if (armor > 0) {
                    probeInfo.progress(armor, armor, probeInfo.defaultProgressStyle().armorBar(true).showText(false).width(80).height(10));
                }
            }
            if (Tools.show(mode, config.getShowMobGrowth()) && entity instanceof AgeableMob && (age = (ageable = (AgeableMob)entity).m_146764_()) < 0) {
                probeInfo.text(CompoundText.createLabelInfo("Growing time: ", age * -1 / 20 + "s"));
            }
            if (Tools.show(mode, config.getShowMobPotionEffects()) && !(effects = livingBase.m_21220_()).isEmpty()) {
                IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1));
                float durationFactor = 1.0f;
                for (MobEffectInstance effect : effects) {
                    CompoundText text = CompoundText.create().info(effect.m_19576_());
                    MobEffect potion = effect.m_19544_();
                    if (!potion.m_19486_()) {
                        text.style(TextStyleClass.ERROR);
                    } else {
                        text.style(TextStyleClass.OK);
                    }
                    if (effect.m_19564_() > 0) {
                        text.text(" ").info("potion.potency." + effect.m_19564_());
                    }
                    if (effect.m_19557_() > 20) {
                        text.text(" (" + DefaultProbeInfoEntityProvider.getPotionDurationString(effect, durationFactor) + ")");
                    }
                    vertical.text(text);
                }
            }
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            ItemStack stack = itemFrame.m_31822_();
            if (!stack.m_41619_()) {
                probeInfo.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).item(stack, new ItemStyle().width(16).height(16)).text(CompoundText.create().info(stack.m_41778_()));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text(CompoundText.createLabelInfo("Rotation: ", itemFrame.m_31823_()));
                }
            } else {
                probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Empty"));
            }
        }
        if (Tools.show(mode, config.getAnimalOwnerSetting())) {
            UUID ownerId = null;
            if (entity instanceof TamableAnimal) {
                TamableAnimal tamable = (TamableAnimal)entity;
                ownerId = tamable.m_142504_();
            } else if (entity instanceof Horse) {
                Horse horse = (Horse)entity;
                ownerId = horse.m_30615_();
            }
            if (ownerId != null) {
                String username = UsernameCache.getLastKnownUsername((UUID)ownerId);
                if (username == null) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text("Unknown owner"));
                } else {
                    probeInfo.text(CompoundText.createLabelInfo("Owned by: ", username));
                }
            } else if (entity instanceof TamableAnimal) {
                probeInfo.text(CompoundText.create().style(TextStyleClass.LABEL).text("Tameable"));
            }
        }
        if (Tools.show(mode, config.getHorseStatSetting()) && entity instanceof Horse) {
            Horse horse = (Horse)entity;
            double jumpStrength = horse.m_30626_();
            double jumpHeight = -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
            probeInfo.text(CompoundText.createLabelInfo("Jump height: ", dfCommas.format(jumpHeight)));
            AttributeInstance attribute = horse.m_21051_(Attributes.f_22279_);
            if (attribute != null) {
                probeInfo.text(CompoundText.createLabelInfo("Speed: ", dfCommas.format(attribute.m_22135_())));
            }
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (((Boolean)Config.showCollarColor.get()).booleanValue() && wolf.m_21824_()) {
                DyeColor collarColor = wolf.m_30428_();
                probeInfo.text(CompoundText.createLabelInfo("Collar: ", collarColor.m_7912_()));
            }
        }
    }

    public static String getPotionDurationString(MobEffectInstance effect, float factor) {
        if (effect.m_19557_() == Short.MAX_VALUE) {
            return "**:**";
        }
        int i = Mth.m_14143_((float)((float)effect.m_19557_() * factor));
        return DefaultProbeInfoEntityProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, Entity entity, IProbeConfig config) {
        String modName = Tools.getModName(entity.m_6095_());
        if (Tools.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text(CompoundText.create().name(entity.m_7755_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text(CompoundText.create().name(entity.m_7755_()));
        }
    }
}

