/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson.api;

import io.socol.betterthirdperson.api.AngleUtils;
import io.socol.betterthirdperson.api.CustomCameraManager;
import io.socol.betterthirdperson.api.TickPhase;
import io.socol.betterthirdperson.api.adapter.IClientAdapter;
import io.socol.betterthirdperson.api.adapter.IMovementInputAdapter;
import io.socol.betterthirdperson.api.adapter.IPlayerAdapter;
import io.socol.betterthirdperson.api.adapter.IPlayerPosition;
import io.socol.betterthirdperson.api.config.CustomCameraConfig;

public class CustomCamera {
    private final CustomCameraManager manager;
    private final CustomCameraConfig config;
    private float followYaw;
    private float cameraYaw;
    private float playerYaw;
    private boolean cameraAligned;
    private IPlayerPosition lastTickPlayerPos;
    private float prevKeyboardInputYaw = 0.0f;
    private float keyboardInputYaw = 0.0f;
    private float mouseInputYaw = 0.0f;
    private boolean isMoving = false;
    private boolean delayMouseActions;
    private long aimTicks = 0L;

    public CustomCamera(CustomCameraManager manager, IPlayerAdapter player, CustomCameraConfig config) {
        this.manager = manager;
        this.config = config;
        this.resetToPlayerView(player);
        this.lastTickPlayerPos = player.getPosition();
    }

    public void handleMovementInputs(IMovementInputAdapter input, IClientAdapter client) {
        boolean mousePressed;
        this.prevKeyboardInputYaw = this.keyboardInputYaw;
        boolean leftKeyDown = input.isLeftKeyDown();
        boolean rightKeyDown = input.isRightKeyDown();
        boolean forwardKeyDown = input.isForwardKeyDown();
        boolean backKeyDown = input.isBackKeyDown();
        boolean wasMoving = this.isMoving;
        this.isMoving = leftKeyDown || rightKeyDown || forwardKeyDown || backKeyDown;
        boolean bl = mousePressed = this.config.shouldAimPlayerOnInteract() && client.isMousePressed();
        if (mousePressed) {
            this.doAim();
        } else if (this.aimTicks > 0L) {
            --this.aimTicks;
            if (this.aimTicks == 0L && this.isMoving) {
                this.keyboardInputYaw = -AngleUtils.normalize(this.getYawDelta());
            }
        }
        if (this.isMoving && this.aimTicks == 0L) {
            if (!wasMoving) {
                this.keyboardInputYaw = -AngleUtils.normalize(this.getYawDelta());
            }
            float targetInputYaw = 0.0f;
            if (forwardKeyDown != backKeyDown) {
                float f = targetInputYaw = forwardKeyDown ? 0.0f : -180.0f;
                if (leftKeyDown != rightKeyDown) {
                    targetInputYaw += (leftKeyDown ? -45.0f : 45.0f) * (float)(forwardKeyDown ? 1 : -1);
                }
            } else if (leftKeyDown != rightKeyDown) {
                targetInputYaw = leftKeyDown ? -90.0f : 90.0f;
            }
            float moveImpulse = Math.max(Math.abs(input.getMoveForward()), Math.abs(input.getMoveStrafe()));
            input.setMoveForward(moveImpulse);
            input.setMoveStrafe(0.0f);
            input.setLeftKeyDown(false);
            input.setRightKeyDown(false);
            input.setBackKeyDown(false);
            input.setForwardKeyDown(true);
            this.keyboardInputYaw += (AngleUtils.wrapAngle(this.keyboardInputYaw, targetInputYaw) - this.keyboardInputYaw) * 0.5f;
        } else {
            this.keyboardInputYaw = 0.0f;
        }
    }

    private void doAim() {
        this.aimTicks = 40L;
    }

    public void handleMouseInput(float deltaYaw) {
        this.mouseInputYaw += deltaYaw;
    }

    public void setup(IClientAdapter client, IPlayerAdapter player, float partialTicks) {
        if (this.mouseInputYaw != 0.0f) {
            if (Math.signum(this.mouseInputYaw) != Math.signum(this.followYaw)) {
                this.followYaw = 0.0f;
            }
            this.followYaw += this.mouseInputYaw;
            this.cameraYaw = AngleUtils.normalize(this.cameraYaw + this.mouseInputYaw);
            if (Math.abs(this.followYaw) <= (float)this.config.getFollowYaw()) {
                this.playerYaw += (float)((double)this.mouseInputYaw * (1.0 - this.easeInExpo(Math.abs(this.followYaw) / (float)this.config.getFollowYaw())));
            }
            this.mouseInputYaw = 0.0f;
        }
        if (this.aimTicks > 0L) {
            this.playerYaw = this.cameraYaw;
        } else if (this.isMoving) {
            this.playerYaw = this.cameraYaw + AngleUtils.smoothAngle(partialTicks, this.prevKeyboardInputYaw, this.keyboardInputYaw);
        }
        if (!AngleUtils.equals(this.playerYaw, player.getRotationYaw())) {
            player.setRotationYaw(this.playerYaw);
            if (player.isPassenger()) {
                player.setVehicleYaw(this.playerYaw);
            }
        }
    }

    public float getYawDelta() {
        return this.cameraYaw - this.playerYaw;
    }

    public void handlePlayerTick(TickPhase phase, IPlayerAdapter player) {
        IPlayerPosition currentPos = player.getPosition();
        if (phase == TickPhase.START) {
            if (!player.isPassenger() && !this.lastTickPlayerPos.equals(currentPos)) {
                this.resetToPlayerView(player);
            }
        } else {
            if (player.isPassenger()) {
                this.onRotationSend();
            }
            this.lastTickPlayerPos = currentPos;
        }
    }

    public void handleMouseReset() {
        this.delayMouseActions = false;
    }

    public boolean handleMouseAction(IPlayerAdapter player, IClientAdapter client) {
        if (this.delayMouseActions) {
            return true;
        }
        if (!this.cameraAligned && this.aimTicks == 0L && this.config.shouldAimPlayerOnInteract()) {
            this.doAim();
            player.setRotationYawSafe(this.cameraYaw);
            client.updateHitResult();
            this.resetToPlayerView(player);
            this.delayMouseActions = true;
            return true;
        }
        return false;
    }

    private void resetToPlayerView(IPlayerAdapter player) {
        this.playerYaw = player.getRotationYaw();
        this.cameraYaw = player.getRotationYaw();
        this.followYaw = 0.0f;
        this.cameraAligned = true;
    }

    private double easeInExpo(double x) {
        return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
    }

    public void onRotationSend() {
        this.cameraAligned = AngleUtils.equals(this.playerYaw, this.cameraYaw);
    }
}

