/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.worldgen;

import java.util.Collection;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.util.WildcardedRLMatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;

public class WorldGenFiltering {
    private static WildcardedRLMatcher dimensionMatcherB = null;
    private static WildcardedRLMatcher dimensionMatcherW = null;
    private static WildcardedRLMatcher biomeMatcherB = null;
    private static WildcardedRLMatcher biomeMatcherW = null;

    public static void clearMatcherCaches() {
        dimensionMatcherB = null;
        dimensionMatcherW = null;
        biomeMatcherB = null;
        biomeMatcherW = null;
    }

    static boolean isBiomeOK(ResourceLocation biomeName) {
        if (biomeMatcherB == null) {
            biomeMatcherB = new WildcardedRLMatcher((Collection)ConfigHelper.common().worldgen.oilWorldGenBlacklist.get());
        }
        if (biomeMatcherW == null) {
            biomeMatcherW = new WildcardedRLMatcher((Collection)ConfigHelper.common().worldgen.oilWorldGenWhitelist.get());
        }
        return biomeMatcherW.isEmpty() ? !biomeMatcherB.test(biomeName) : biomeMatcherW.test(biomeName);
    }

    static boolean isDimensionOK(WorldGenLevel level) {
        if (dimensionMatcherB == null) {
            dimensionMatcherB = new WildcardedRLMatcher((Collection)ConfigHelper.common().worldgen.oilWorldGenDimensionBlacklist.get());
        }
        if (dimensionMatcherW == null) {
            dimensionMatcherW = new WildcardedRLMatcher((Collection)ConfigHelper.common().worldgen.oilWorldGenDimensionWhitelist.get());
        }
        ResourceLocation name = level.m_6018_().m_46472_().m_135782_();
        return dimensionMatcherW.isEmpty() ? !dimensionMatcherB.test(name) : dimensionMatcherW.test(name);
    }
}

