/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class FluidUtils {
    public static boolean tryFluidExtraction(IFluidHandler srcHandler, ItemStack destStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)destStack, (IFluidHandler)srcHandler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            destStack.m_41774_(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(IFluidHandler handler, ItemStack srcStack, NonNullList<ItemStack> returnedItems) {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)srcStack, (IFluidHandler)handler, (int)1000, null, (boolean)true);
        if (result.isSuccess()) {
            returnedItems.add((Object)result.getResult());
            srcStack.m_41774_(1);
            return true;
        }
        return false;
    }

    public static boolean tryFluidInsertion(BlockEntity te, Direction face, Player player, InteractionHand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, true);
    }

    public static boolean tryFluidExtraction(BlockEntity te, Direction face, Player player, InteractionHand hand) {
        return FluidUtils.doFluidInteraction(te, face, player, hand, false);
    }

    private static boolean doFluidInteraction(BlockEntity te, Direction face, Player player, InteractionHand hand, boolean isInserting) {
        ItemStack stack = player.m_21120_(hand);
        return FluidUtil.getFluidHandler((ItemStack)stack).map(stackHandler -> {
            if (te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).isPresent()) {
                if (stackHandler.getTanks() == 0) {
                    return false;
                }
                int capacity = stackHandler.getTankCapacity(0);
                return te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).map(handler -> {
                    FluidActionResult result;
                    PlayerInvWrapper invWrapper = new PlayerInvWrapper(player.m_150109_());
                    FluidActionResult fluidActionResult = result = isInserting ? FluidUtils.tryEmptyContainerAndStow(player.m_21120_(hand), handler, (IItemHandler)invWrapper, capacity, player, true) : FluidUtil.tryFillContainerAndStow((ItemStack)player.m_21120_(hand), (IFluidHandler)handler, (IItemHandler)invWrapper, (int)capacity, (Player)player, (boolean)true);
                    if (result.isSuccess()) {
                        player.m_21008_(hand, result.getResult());
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            return false;
        }).orElse(false);
    }

    public static boolean isSourceFluidBlock(Level world, BlockPos pos) {
        return FluidUtils.isSourceFluidBlock(world, pos, null);
    }

    public static boolean isSourceFluidBlock(Level world, BlockPos pos, @Nullable Fluid fluid) {
        FluidState state = world.m_6425_(pos);
        return state.m_76170_() && fluid == null || state.m_76152_() == fluid;
    }

    public static boolean isFlowingFluidBlock(Level world, BlockPos pos) {
        return FluidUtils.isFlowingFluidBlock(world, pos, null);
    }

    public static boolean isFlowingFluidBlock(Level world, BlockPos pos, @Nullable Fluid fluid) {
        FluidState state = world.m_6425_(pos);
        return !state.m_76178_() && !state.m_76170_() && (fluid == null || fluid == state.m_76152_());
    }

    public static FluidStack tryPickupFluid(LazyOptional<IFluidHandler> fluidCap, Level world, BlockPos pos, boolean playSound, IFluidHandler.FluidAction action) {
        FluidStack transferred;
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof BucketPickup)) {
            return FluidStack.EMPTY;
        }
        FluidState fluidState = state.m_60819_();
        Fluid fluid = fluidState.m_76152_();
        if (fluid == Fluids.f_76191_ || !fluid.m_7444_(fluidState)) {
            return FluidStack.EMPTY;
        }
        FluidTank tank = new FluidTank(1000);
        tank.setFluid(new FluidStack(fluid, 1000));
        FluidStack maybeSent = fluidCap.map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)tank, (int)1000, (boolean)false)).orElse(FluidStack.EMPTY);
        if (maybeSent.getAmount() != 1000) {
            return FluidStack.EMPTY;
        }
        boolean removeBlock = true;
        if (fluid == Fluids.f_76193_ && ((Boolean)ConfigHelper.common().advanced.dontUpdateInfiniteWaterSources.get()).booleanValue()) {
            int n = 0;
            for (Direction d : DirectionUtil.HORIZONTALS) {
                if (world.m_6425_(pos.m_142300_(d)).m_76152_() != Fluids.f_76193_ || ++n < 2) continue;
                removeBlock = false;
                break;
            }
        }
        if (removeBlock && action.execute()) {
            ((BucketPickup)state.m_60734_()).m_142598_((LevelAccessor)world, pos, state);
        }
        if (!(transferred = fluidCap.map(h -> FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)tank, (int)1000, (boolean)action.execute())).orElse(FluidStack.EMPTY)).isEmpty() && playSound) {
            FluidUtils.playFillSound(world, pos, fluid);
        }
        return transferred;
    }

    public static boolean tryPourOutFluid(LazyOptional<IFluidHandler> fluidCap, Level world, BlockPos pos, boolean playSound, boolean force, IFluidHandler.FluidAction action) {
        boolean isNotSolid;
        BlockState blockstate = world.m_8055_(pos);
        Material material = blockstate.m_60767_();
        boolean isReplaceable = material.m_76336_();
        boolean bl = isNotSolid = !material.m_76333_();
        if (!force && (FluidUtils.isSourceFluidBlock(world, pos) || !isReplaceable && !(blockstate.m_60734_() instanceof LiquidBlockContainer))) {
            return false;
        }
        boolean didWork = fluidCap.map(handler -> {
            FluidStack toPlace = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (toPlace.getAmount() < 1000) {
                return false;
            }
            Fluid fluid = toPlace.getFluid();
            Block block = blockstate.m_60734_();
            if (world.m_46859_(pos) || isNotSolid || isReplaceable || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, blockstate, toPlace.getFluid())) {
                if (action.execute()) {
                    if (world.m_6042_().m_63951_() && fluid.m_205067_(FluidTags.f_13131_)) {
                        FluidUtils.playEvaporationEffects(world, pos);
                    } else if (block instanceof LiquidBlockContainer) {
                        FluidState still;
                        FluidState fluidState = still = fluid instanceof FlowingFluid ? ((FlowingFluid)fluid).m_76068_(false) : fluid.m_76145_();
                        if (((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, pos, blockstate, still) && playSound) {
                            FluidUtils.playEmptySound(world, pos, fluid);
                        }
                    } else {
                        if (playSound) {
                            FluidUtils.playEmptySound(world, pos, fluid);
                        }
                        if (isNotSolid || isReplaceable) {
                            world.m_46961_(pos, true);
                        }
                        world.m_7731_(pos, fluid.m_76145_().m_76188_(), 3);
                    }
                }
                return true;
            }
            return false;
        }).orElse(false);
        if (didWork && action.execute()) {
            fluidCap.ifPresent(handler -> handler.drain(1000, IFluidHandler.FluidAction.EXECUTE));
        }
        return didWork;
    }

    private static void playEmptySound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundevent = fluid.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        world.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void playFillSound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getAttributes().getFillSound();
        if (soundEvent == null) {
            soundEvent = fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11783_ : SoundEvents.f_11781_;
        }
        world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void playEvaporationEffects(Level world, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public static boolean matchFluid(FluidIngredient fluidIngredient, FluidStack fluidStack, boolean matchTags) {
        return fluidIngredient.testFluid(fluidStack);
    }

    public static boolean matchFluid(FluidIngredient fluidIngredient, Fluid fluid, boolean matchTags) {
        return fluidIngredient.testFluid(fluid);
    }

    @Nonnull
    private static FluidActionResult tryEmptyContainerAndStow(@Nonnull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doDrain) {
        if (container.m_41619_()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.m_150110_().f_35937_) {
            FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.m_41613_() == 1) {
            FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).m_41619_() || player != null)) {
                FluidActionResult emptiedReal = FluidUtils.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.m_41619_() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.m_41777_();
                containerCopy.m_41774_(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    private static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null) {
                SoundEvent soundevent = transfer.getFluid().getAttributes().getEmptySound(transfer);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }
}

