/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import me.desht.pneumaticcraft.common.tubemodules.IInfluenceDispersing;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;

public class RegulatorModule
extends AbstractRedstoneReceivingModule
implements IInfluenceDispersing {
    private LazyOptional<IAirHandlerMachine> neighbourCap = null;

    public RegulatorModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.REGULATOR_TUBE_MODULE.get();
    }

    @Override
    public int getMaxDispersion() {
        return this.getCachedNeighbourAirHandler().map(h -> {
            int maxDispersion = (int)((this.getThreshold() - h.getPressure()) * (float)h.getVolume());
            return Math.max(0, maxDispersion);
        }).orElse(0);
    }

    @Override
    public void onAirDispersion(int amount) {
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.neighbourCap = null;
    }

    @Override
    public float getThreshold() {
        return this.upgraded ? super.getThreshold() : 4.9f * (float)(15 - this.getReceivingRedstoneLevel()) / 15.0f;
    }

    private LazyOptional<IAirHandlerMachine> getCachedNeighbourAirHandler() {
        if (this.neighbourCap == null) {
            BlockEntity neighborTE = this.pressureTube.nonNullLevel().m_7702_(this.pressureTube.m_58899_().m_142300_(this.dir));
            if (neighborTE != null) {
                this.neighbourCap = neighborTE.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, this.dir.m_122424_());
                if (this.neighbourCap.isPresent()) {
                    this.neighbourCap.addListener(l -> {
                        this.neighbourCap = null;
                    });
                }
            } else {
                this.neighbourCap = LazyOptional.empty();
            }
        }
        return this.neighbourCap;
    }

    @Override
    public boolean isInlineAndFocused(PressureTubeBlock.TubeHitInfo hitInfo) {
        return hitInfo.dir() == this.getDirection() || hitInfo == PressureTubeBlock.TubeHitInfo.CENTER;
    }
}

