/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ModuleNetworkManager {
    private static final Map<ResourceLocation, ModuleNetworkManager> INSTANCES = new HashMap<ResourceLocation, ModuleNetworkManager>();
    private final Map<AbstractTubeModule, Set<AbstractTubeModule>> connectionCache = new HashMap<AbstractTubeModule, Set<AbstractTubeModule>>();
    private boolean needInvalidate = false;

    public static ModuleNetworkManager getInstance(Level w) {
        return INSTANCES.computeIfAbsent(w.m_46472_().m_135782_(), dimId -> new ModuleNetworkManager());
    }

    Set<AbstractTubeModule> getConnectedModules(AbstractTubeModule module) {
        if (this.needInvalidate) {
            this.connectionCache.clear();
            this.needInvalidate = false;
        }
        return this.connectionCache.computeIfAbsent(module, this::computeConnections);
    }

    public void invalidateCache() {
        this.needInvalidate = true;
    }

    private Set<AbstractTubeModule> computeConnections(AbstractTubeModule module) {
        HashSet<AbstractTubeModule> modules = new HashSet<AbstractTubeModule>();
        HashSet<BlockEntity> traversedTubes = new HashSet<BlockEntity>();
        Stack<PressureTubeBlockEntity> pendingTubes = new Stack<PressureTubeBlockEntity>();
        pendingTubes.push(module.getTube());
        while (!pendingTubes.isEmpty()) {
            PressureTubeBlockEntity tube = (PressureTubeBlockEntity)pendingTubes.pop();
            tube.tubeModules().filter(tm -> tm instanceof INetworkedModule && module.getClass() == tm.getClass()).forEach(modules::add);
            for (Direction dir : DirectionUtil.VALUES) {
                BlockEntity newTube = tube.getConnectedNeighbor(dir);
                if (!(newTube instanceof PressureTubeBlockEntity) || traversedTubes.contains(newTube)) continue;
                pendingTubes.add((PressureTubeBlockEntity)newTube);
                traversedTubes.add(newTube);
            }
        }
        return modules;
    }
}

