/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EntityProvider {

    public static class Component
    implements IEntityComponentProvider {
        public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
            Entity entity;
            if (entityAccessor.getServerData().m_128441_("Pressure")) {
                float pressure = entityAccessor.getServerData().m_128457_("Pressure");
                iTooltip.add((net.minecraft.network.chat.Component)new TranslatableComponent("pneumaticcraft.gui.tooltip.pressure", new Object[]{PneumaticCraftUtils.roundNumberTo(pressure, 1)}));
            }
            if (entityAccessor.getServerData().m_128441_("Temperature")) {
                iTooltip.add(HeatUtil.formatHeatString(entityAccessor.getServerData().m_128451_("Temperature")));
            }
            if ((entity = entityAccessor.getEntity()) instanceof ISemiBlock) {
                ISemiBlock semiBlock = (ISemiBlock)entity;
                semiBlock.addTooltip(arg_0 -> ((ITooltip)iTooltip).add(arg_0), entityAccessor.getPlayer(), entityAccessor.getServerData(), entityAccessor.getPlayer().m_6144_());
                BlockPos pos = semiBlock.getBlockPos();
                BlockState state = entityAccessor.getLevel().m_8055_(pos);
                iTooltip.add((net.minecraft.network.chat.Component)state.m_60734_().m_49954_().m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    public static class Data
    implements IServerDataProvider<Entity> {
        public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, Entity entity, boolean b) {
            entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> compoundTag.m_128350_("Pressure", h.getPressure()));
            entity.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(h -> compoundTag.m_128350_("Temperature", (float)h.getTemperatureAsInt()));
            if (entity instanceof ISemiBlock) {
                ISemiBlock s = (ISemiBlock)entity;
                s.serializeNBT(compoundTag);
            }
        }
    }
}

