/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.ghost;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AmadronAddTradeScreen;
import me.desht.pneumaticcraft.common.inventory.AmadronAddTradeMenu;
import me.desht.pneumaticcraft.common.inventory.slot.PhantomSlot;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AmadronAddTradeGhost
implements IGhostIngredientHandler<AmadronAddTradeScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AmadronAddTradeScreen gui, I ingredient, boolean doStart) {
        if (ingredient instanceof ItemStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Slot slot : ((AmadronAddTradeMenu)gui.m_6262_()).f_38839_) {
                if (!(slot instanceof PhantomSlot)) continue;
                builder.add((Object)new ItemStackTarget((PhantomSlot)slot, gui));
            }
            return builder.build();
        }
        if (ingredient instanceof FluidStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Slot slot : ((AmadronAddTradeMenu)gui.m_6262_()).f_38839_) {
                if (!(slot instanceof PhantomSlot)) continue;
                builder.add((Object)new FluidStackTarget((PhantomSlot)slot, gui));
            }
            return builder.build();
        }
        return Collections.emptyList();
    }

    public void onComplete() {
    }

    private static class ItemStackTarget
    extends TargetImpl<ItemStack> {
        ItemStackTarget(PhantomSlot slot, AmadronAddTradeScreen gui) {
            super(slot, gui);
        }

        public void accept(ItemStack ingredient) {
            this.gui.setStack(this.slot.getSlotIndex(), ingredient);
        }
    }

    private static class FluidStackTarget
    extends TargetImpl<FluidStack> {
        FluidStackTarget(PhantomSlot slot, AmadronAddTradeScreen gui) {
            super(slot, gui);
        }

        public void accept(FluidStack ingredient) {
            this.gui.setFluid(this.slot.getSlotIndex(), ingredient.getFluid());
        }
    }

    private static abstract class TargetImpl<I>
    implements IGhostIngredientHandler.Target<I> {
        final PhantomSlot slot;
        final AmadronAddTradeScreen gui;

        TargetImpl(PhantomSlot slot, AmadronAddTradeScreen gui) {
            this.slot = slot;
            this.gui = gui;
        }

        public Rect2i getArea() {
            return new Rect2i(this.gui.getGuiLeft() + this.slot.f_40220_, this.gui.getGuiTop() + this.slot.f_40221_, 16, 16);
        }
    }
}

