/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.immersiveengineering;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

class IEHeatHandler {
    IEHeatHandler() {
    }

    public static class Provider
    implements ICapabilityProvider {
        private final Impl impl;
        private final LazyOptional<ExternalHeaterHandler.IExternalHeatable> lazy;

        public Provider(BlockEntity blockEntity) {
            this.impl = new Impl(blockEntity);
            this.lazy = LazyOptional.of(() -> this.impl);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return ExternalHeaterHandler.CAPABILITY.orEmpty(cap, this.lazy);
        }

        public void invalidate() {
            this.lazy.invalidate();
        }
    }

    public static class Impl
    implements ExternalHeaterHandler.IExternalHeatable {
        private final BlockEntity blockEntity;

        public Impl(BlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        public int doHeatTick(int energyAvailable, boolean redstone) {
            return this.blockEntity.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).map(handler -> {
                int rfPerTick = (Integer)ConfigHelper.common().integration.ieExternalHeaterFEperTick.get();
                double heatPerRF = (Double)ConfigHelper.common().integration.ieExternalHeaterHeatPerFE.get();
                if (energyAvailable >= rfPerTick) {
                    handler.addHeat((double)rfPerTick * heatPerRF);
                    return rfPerTick;
                }
                return 0;
            }).orElse(0);
        }
    }
}

