/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.common.block.RefineryControllerBlock;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class RefineryRecipeImpl
extends RefineryRecipe {
    public final FluidIngredient input;
    public final List<FluidStack> outputs;
    private final TemperatureRange operatingTemp;

    public RefineryRecipeImpl(ResourceLocation id, FluidIngredient input, TemperatureRange operatingTemp, FluidStack ... outputs) {
        super(id);
        this.operatingTemp = operatingTemp;
        Validate.isTrue((outputs.length >= 2 && outputs.length <= 4 ? 1 : 0) != 0, (String)"Recipe must have between 2 and 4 (inclusive) outputs", (Object[])new Object[0]);
        this.input = input;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
    }

    @Override
    public FluidIngredient getInput() {
        return this.input;
    }

    @Override
    public List<FluidStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public TemperatureRange getOperatingTemp() {
        return this.operatingTemp;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        this.operatingTemp.write(buffer);
        buffer.m_130130_(this.outputs.size());
        this.outputs.forEach(fluidStack -> fluidStack.writeToPacket(buffer));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.REFINERY.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.REFINERY.get();
    }

    public String m_6076_() {
        return ((RefineryControllerBlock)ModBlocks.REFINERY.get()).getRegistryName().m_135815_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.REFINERY.get());
    }

    public static class Serializer<T extends RefineryRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = FluidIngredient.m_43917_((JsonElement)json.get("input"));
            TemperatureRange tempRange = json.has("temperature") ? TemperatureRange.fromJson(json.getAsJsonObject("temperature")) : TemperatureRange.min(373);
            JsonArray outputs = json.get("results").getAsJsonArray();
            if (outputs.size() < 2 || outputs.size() > 4) {
                throw new JsonSyntaxException("must be between 2 and 4 (inclusive) output fluids!");
            }
            ArrayList<FluidStack> results = new ArrayList<FluidStack>();
            for (JsonElement element : outputs) {
                results.add(ModCraftingHelper.fluidStackFromJson(element.getAsJsonObject()));
            }
            return this.factory.create(recipeId, (FluidIngredient)input, tempRange, results.toArray(new FluidStack[0]));
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidIngredient input = (FluidIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer);
            TemperatureRange range = TemperatureRange.read(buffer);
            int nOutputs = buffer.m_130242_();
            FluidStack[] outputs = new FluidStack[nOutputs];
            for (int i = 0; i < nOutputs; ++i) {
                outputs[i] = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            }
            return this.factory.create(recipeId, input, range, outputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends RefineryRecipe> {
            public T create(ResourceLocation var1, FluidIngredient var2, TemperatureRange var3, FluidStack ... var4);
        }
    }
}

