/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExplosionCraftingRecipeImpl
extends ExplosionCraftingRecipe {
    private static final NonNullList<ItemStack> EMPTY_RESULT = NonNullList.m_122779_();
    private final Ingredient input;
    private final List<ItemStack> outputs;
    private final int lossRate;

    public ExplosionCraftingRecipeImpl(ResourceLocation id, Ingredient input, int lossRate, ItemStack ... outputs) {
        super(id);
        this.input = input;
        this.outputs = Arrays.asList(outputs);
        this.lossRate = lossRate;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getAmount() {
        return this.input.m_43908_().length > 0 ? this.input.m_43908_()[0].m_41613_() : 0;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public int getLossRate() {
        return this.lossRate;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack) && stack.m_41613_() >= this.getAmount();
    }

    public static NonNullList<ItemStack> tryToCraft(Level world, ItemStack stack) {
        ExplosionCraftingRecipe recipe = ((PneumaticCraftRecipeType)ModRecipeTypes.EXPLOSION_CRAFTING.get()).findFirst(world, r -> r.matches(stack));
        return recipe == null || recipe.getAmount() == 0 ? EMPTY_RESULT : ExplosionCraftingRecipeImpl.createOutput(recipe, stack);
    }

    private static NonNullList<ItemStack> createOutput(ExplosionCraftingRecipe recipe, ItemStack stack) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int lossRate = recipe.getLossRate();
        NonNullList res = NonNullList.m_122779_();
        int inputCount = Math.round((float)stack.m_41613_() / (float)recipe.getAmount());
        if (inputCount >= 3 || ((Random)rand).nextDouble() >= (double)lossRate / 100.0) {
            for (ItemStack s : recipe.getOutputs()) {
                ItemStack newStack = s.m_41777_();
                if (inputCount >= 3) {
                    newStack.m_41764_((int)((double)inputCount * (((Random)rand).nextDouble() * Math.min((double)lossRate * 0.02, 0.2) + (Math.max(0.9, 1.0 - (double)lossRate * 0.01) - (double)lossRate * 0.01))));
                }
                res.add((Object)newStack);
            }
        }
        return res;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.m_130130_(this.outputs.size());
        this.outputs.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        buffer.m_130130_(this.lossRate);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.EXPLOSION_CRAFTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.EXPLOSION_CRAFTING.get();
    }

    public String m_6076_() {
        return "explosion_crafting";
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Blocks.f_50077_);
    }

    public static class Serializer<T extends ExplosionCraftingRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            int loss_rate = GsonHelper.m_13824_((JsonObject)json, (String)"loss_rate", (int)0);
            JsonArray outputs = json.get("results").getAsJsonArray();
            NonNullList results = NonNullList.m_122779_();
            for (JsonElement e : outputs) {
                results.add((Object)ShapedRecipe.m_151274_((JsonObject)e.getAsJsonObject()));
            }
            return this.factory.create(recipeId, input, loss_rate, (ItemStack[])results.toArray((Object[])new ItemStack[0]));
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int nOutputs = buffer.m_130242_();
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            for (int i = 0; i < nOutputs; ++i) {
                l.add(buffer.m_130267_());
            }
            int lossRate = buffer.m_130242_();
            return this.factory.create(recipeId, input, lossRate, l.toArray(new ItemStack[0]));
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends ExplosionCraftingRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, int var3, ItemStack ... var4);
        }
    }
}

