/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AreaTypeGrid
extends AreaType {
    public static final String ID = "grid";
    private int interval;

    public AreaTypeGrid() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.interval;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (p1.equals((Object)p2) || this.interval <= 0) {
            areaAdder.accept(p1);
        } else {
            for (int x = minX; x <= maxX; x += this.interval) {
                for (int y = minY; y <= maxY; y += this.interval) {
                    for (int z = minZ; z <= maxZ; z += this.interval) {
                        areaAdder.accept(new BlockPos(x, y, z));
                    }
                }
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetInteger("pneumaticcraft.gui.progWidget.area.type.grid.interval", () -> this.interval, interval -> {
            this.interval = interval;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128405_("interval", this.interval);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.interval = tag.m_128451_("interval");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.m_130130_(this.interval);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.interval = buf.m_130242_();
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        this.interval = typeInfo;
    }
}

