/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public abstract class AreaType {
    private final String translationKey;
    private final String name;

    public AreaType(String name) {
        this.name = name;
        this.translationKey = String.format("pneumaticcraft.gui.progWidget.area.type.%s.name", name);
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public abstract void addArea(Consumer<BlockPos> var1, BlockPos var2, BlockPos var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldType, int typeInfo) {
    }

    public boolean isDeterministic() {
        return true;
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
    }

    public void readFromPacket(FriendlyByteBuf buf) {
    }

    public void writeToNBT(CompoundTag tag) {
    }

    public void readFromNBT(CompoundTag tag) {
    }

    public void addUIWidgets(List<AreaTypeWidget> widgets) {
    }

    public static class AreaTypeWidgetEnum<E extends Enum<?>>
    extends AreaTypeWidget {
        public final Class<E> enumClass;
        public final Supplier<E> readAction;
        public final Consumer<E> writeAction;

        public AreaTypeWidgetEnum(String title, Class<E> enumClass, Supplier<E> readAction, Consumer<E> writeAction) {
            super(title);
            this.enumClass = enumClass;
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public String getCurValue() {
            return ((Enum)this.readAction.get()).toString();
        }
    }

    public static class AreaTypeWidgetInteger
    extends AreaTypeWidget {
        public final Supplier<Integer> readAction;
        public final Consumer<Integer> writeAction;

        public AreaTypeWidgetInteger(String title, Supplier<Integer> readAction, Consumer<Integer> writeAction) {
            super(title);
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public String getCurValue() {
            return this.readAction.get().toString();
        }
    }

    public static abstract class AreaTypeWidget {
        public final String title;

        public AreaTypeWidget(String title) {
            this.title = title;
        }

        public abstract String getCurValue();
    }

    public static enum EnumAxis {
        X,
        Y,
        Z;

    }
}

