/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProgWidgetPressureCondition
extends ProgWidgetCondition {
    public ProgWidgetPressureCondition() {
        super((ProgWidgetType)((Object)ModProgWidgets.CONDITION_PRESSURE.get()));
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.AREA.get()))), (Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.TEXT.get()))));
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.world().m_7702_(pos);
                if (te != null) {
                    float pressure = Float.MIN_VALUE;
                    for (Direction d : DirectionUtil.VALUES) {
                        if (!ProgWidgetPressureCondition.this.getSides()[d.ordinal()]) continue;
                        float p = te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, d).map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f)).floatValue();
                        pressure = Math.max(pressure, p);
                    }
                    ProgWidgetPressureCondition.this.maybeRecordMeasuredVal(this.drone, (int)(pressure * 1000.0f));
                    return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(pressure, (float)((ICondition)((Object)this.progWidget)).getRequiredCount());
                }
                return false;
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_PRESSURE;
    }
}

