/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.BlockTrackLootable;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.Validate;

public enum CommonArmorRegistry implements ICommonArmorRegistry
{
    INSTANCE;

    public final Map<Class<? extends Entity>, Supplier<? extends IHackableEntity>> hackableEntities = new ConcurrentHashMap<Class<? extends Entity>, Supplier<? extends IHackableEntity>>();
    public final Map<ResourceLocation, Supplier<? extends IHackableEntity>> idToEntityHackables = new ConcurrentHashMap<ResourceLocation, Supplier<? extends IHackableEntity>>();
    private final Multimap<EntityType<?>, IHackableEntity> hackablesByType = ArrayListMultimap.create();
    private final Map<Block, Supplier<? extends IHackableBlock>> hackableBlocks = new ConcurrentHashMap<Block, Supplier<? extends IHackableBlock>>();
    private final Map<Block, Supplier<? extends IHackableBlock>> hackableTaggedBlocks = new ConcurrentHashMap<Block, Supplier<? extends IHackableBlock>>();
    private final Map<TagKey<Block>, Supplier<? extends IHackableBlock>> pendingBlockTags = new ConcurrentHashMap<TagKey<Block>, Supplier<? extends IHackableBlock>>();
    private final Map<ResourceLocation, Supplier<? extends IHackableBlock>> idToBlockHackables = new ConcurrentHashMap<ResourceLocation, Supplier<? extends IHackableBlock>>();

    public static CommonArmorRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public synchronized <T extends IArmorUpgradeHandler<?>> T registerUpgradeHandler(T handler) {
        Validate.notNull(handler, (String)"Upgrade handler can't be null!", (Object[])new Object[0]);
        return ArmorUpgradeRegistry.getInstance().registerUpgradeHandler(handler);
    }

    @Override
    public ICommonArmorHandler getCommonArmorHandler(Player player) {
        return CommonArmorHandler.getHandlerForPlayer(player);
    }

    @Override
    public void addHackable(Class<? extends Entity> entityClazz, Supplier<? extends IHackableEntity> iHackable) {
        Validate.isTrue((!(iHackable instanceof Entity) ? 1 : 0) != 0, (String)"Entities that already implement IHackableEntity do not need to be registered as hackable!", (Object[])new Object[0]);
        IHackableEntity hackableEntity = iHackable.get();
        if (hackableEntity.getHackableId() != null) {
            this.idToEntityHackables.put(hackableEntity.getHackableId(), iHackable);
        }
        this.hackableEntities.put(entityClazz, iHackable);
    }

    @Override
    public void addHackable(Block block, Supplier<? extends IHackableBlock> iHackable) {
        Validate.isTrue((!(iHackable instanceof Block) ? 1 : 0) != 0, (String)"Blocks that already implement IHackableBlock do not need to be registered as hackable!", (Object[])new Object[0]);
        IHackableBlock hackableBlock = iHackable.get();
        if (hackableBlock.getHackableId() != null) {
            this.idToBlockHackables.put(hackableBlock.getHackableId(), iHackable);
        }
        this.hackableBlocks.put(block, iHackable);
    }

    @Override
    public void addHackable(TagKey<Block> blockTag, Supplier<? extends IHackableBlock> iHackable) {
        Validate.isTrue((!(iHackable instanceof Block) ? 1 : 0) != 0, (String)"Blocks that already implement IHackableBlock do not need to be registered as hackable!", (Object[])new Object[0]);
        this.pendingBlockTags.put(blockTag, iHackable);
    }

    @Override
    public List<IHackableEntity> getCurrentEntityHacks(Entity entity) {
        return entity.getCapability(PNCCapabilities.HACKING_CAPABILITY).map(IHacking::getCurrentHacks).orElse(Collections.emptyList());
    }

    @Override
    public void registerBlockTrackerLootable(BiConsumer<Player, BlockEntity> consumer) {
        BlockTrackLootable.INSTANCE.addLootable(consumer);
    }

    public void resolveBlockTags() {
        this.hackableTaggedBlocks.clear();
        this.pendingBlockTags.forEach((tagKey, hackable) -> Registry.f_122824_.m_206058_(tagKey).forEach(arg_0 -> this.lambda$resolveBlockTags$0((Supplier)hackable, arg_0)));
    }

    public IHackableBlock getHackable(Block block) {
        Supplier<? extends IHackableBlock> sup = this.hackableBlocks.get(block);
        if (sup != null) {
            return sup.get();
        }
        sup = this.hackableTaggedBlocks.get(block);
        return sup == null ? null : sup.get();
    }

    public IHackableEntity getHackable(Entity entity, Player player) {
        if (!this.hackablesByType.containsKey((Object)entity.m_6095_())) {
            for (Map.Entry<Class<? extends Entity>, Supplier<? extends IHackableEntity>> entry : this.hackableEntities.entrySet()) {
                if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
                this.hackablesByType.put((Object)entity.m_6095_(), (Object)entry.getValue().get());
            }
        }
        return this.hackablesByType.get((Object)entity.m_6095_()).stream().filter(hackable -> hackable.canHack(entity, player)).findFirst().orElse(null);
    }

    public IHackableEntity getHackableForId(ResourceLocation id) {
        Supplier<? extends IHackableEntity> sup = this.idToEntityHackables.get(id);
        return sup == null ? null : sup.get();
    }

    private /* synthetic */ void lambda$resolveBlockTags$0(Supplier hackable, Holder h) {
        this.hackableTaggedBlocks.put((Block)h.m_203334_(), hackable);
    }
}

