/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketUpdateSearchItem {
    private final ResourceLocation itemId;

    public PacketUpdateSearchItem(Item item) {
        this.itemId = item.getRegistryName();
    }

    public PacketUpdateSearchItem(FriendlyByteBuf buffer) {
        this.itemId = buffer.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.itemId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)player);
            if (handler.upgradeUsable(CommonUpgradeHandlers.searchHandler, true)) {
                ItemStack helmetStack = player.m_6844_(EquipmentSlot.HEAD);
                Item searchedItem = (Item)ForgeRegistries.ITEMS.getValue(this.itemId);
                if (searchedItem != null && searchedItem != Items.f_41852_) {
                    PneumaticArmorItem.setSearchedItem(helmetStack, searchedItem);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

