/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketToggleArmorFeature {
    private final byte featureIndex;
    private final boolean state;
    private final EquipmentSlot slot;

    public PacketToggleArmorFeature(EquipmentSlot slot, byte featureIndex, boolean state) {
        this.featureIndex = featureIndex;
        this.state = state;
        this.slot = slot;
    }

    PacketToggleArmorFeature(FriendlyByteBuf buffer) {
        this.featureIndex = buffer.readByte();
        this.state = buffer.readBoolean();
        this.slot = EquipmentSlot.values()[buffer.readByte()];
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.featureIndex);
        buf.writeBoolean(this.state);
        buf.writeByte(this.slot.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && this.featureIndex >= 0 && this.featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(this.slot).size() && (PneumaticArmorItem.isPneumaticArmorPiece((Player)player, this.slot) || this.slot == EquipmentSlot.HEAD && this.featureIndex == 0)) {
                CommonArmorHandler.getHandlerForPlayer((Player)player).setUpgradeEnabled(this.slot, this.featureIndex, this.state);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

