/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.semiblock.ISyncableSemiblockItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketSyncSemiblock {
    private final int entityID;
    private final FriendlyByteBuf payload;

    public PacketSyncSemiblock(ISemiBlock semiBlock, boolean itemContainer) {
        this.entityID = itemContainer ? -1 : semiBlock.getTrackingId();
        this.payload = new FriendlyByteBuf(Unpooled.buffer());
        semiBlock.writeToBuf(this.payload);
    }

    PacketSyncSemiblock(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        int size = buffer.m_130242_();
        this.payload = new FriendlyByteBuf(Unpooled.buffer());
        buffer.readBytes((ByteBuf)this.payload, size);
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.m_130130_(this.payload.writerIndex());
        buffer.writeBytes((ByteBuf)this.payload);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                this.handleClient();
            } else {
                this.handleServer(((NetworkEvent.Context)ctx.get()).getSender());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleServer(ServerPlayer sender) {
        if (this.entityID == -1) {
            AbstractContainerMenu abstractContainerMenu = sender.f_36096_;
            if (abstractContainerMenu instanceof ISyncableSemiblockItem) {
                ISyncableSemiblockItem syncable = (ISyncableSemiblockItem)abstractContainerMenu;
                syncable.syncSemiblockItemFromClient((Player)sender, this.payload);
            } else {
                Log.warning("PacketSyncSemiblock: received packet with entity -1, but player is not holding a semiblock item?", new Object[0]);
            }
        } else {
            this.processEntity((Level)sender.m_183503_());
        }
    }

    private void handleClient() {
        Validate.isTrue((this.entityID >= 0 ? 1 : 0) != 0);
        this.processEntity(ClientUtils.getClientLevel());
    }

    private void processEntity(Level world) {
        ISemiBlock semiBlock = ISemiBlock.byTrackingId(world, this.entityID);
        if (semiBlock != null) {
            semiBlock.readFromBuf(this.payload);
        } else {
            Log.warning("PacketSyncSemiblock: did not get expected ISemiBlock entity for entity ID %d", this.entityID);
        }
    }
}

