/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.RemoteScreen;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketSetGlobalVariable {
    private final String varName;
    private final Either<BlockPos, ItemStack> value;

    public PacketSetGlobalVariable(String varName, BlockPos value) {
        Validate.isTrue((varName.startsWith("#") || varName.startsWith("%") ? 1 : 0) != 0);
        this.value = Either.left((Object)value);
        this.varName = varName.startsWith("#") ? varName.substring(1) : varName;
    }

    public PacketSetGlobalVariable(String varName, @Nonnull ItemStack stack) {
        Validate.isTrue((varName.startsWith("#") || varName.startsWith("%") ? 1 : 0) != 0);
        this.value = Either.right((Object)stack);
        this.varName = varName;
    }

    public PacketSetGlobalVariable(String varName, int value) {
        this(varName, new BlockPos(value, 0, 0));
    }

    public PacketSetGlobalVariable(String varName, boolean value) {
        this(varName, value ? 1 : 0);
    }

    public PacketSetGlobalVariable(FriendlyByteBuf buf) {
        this.value = buf.readBoolean() ? Either.left((Object)(buf.readBoolean() ? buf.m_130135_() : null)) : Either.right((Object)buf.m_130267_());
        this.varName = buf.m_130136_(64);
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.value.ifLeft(pos -> {
            buf.writeBoolean(true);
            buf.writeBoolean(pos != null);
            if (pos != null) {
                buf.m_130064_(pos);
            }
        }).ifRight(stack -> {
            buf.writeBoolean(false);
            buf.writeItemStack(stack, true);
        });
        buf.m_130070_(this.varName);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player p = ((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT ? ClientUtils.getClientPlayer() : (Player)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender());
            this.value.ifLeft(pos -> GlobalVariableHelper.setPos(p.m_142081_(), this.varName, pos)).ifRight(stack -> GlobalVariableHelper.setStack(p.m_142081_(), this.varName, stack));
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                RemoteScreen.maybeHandleVariableChange(this.varName);
                AreaRenderManager.getInstance().clearPosProviderCache();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

