/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class PacketModWrenchBlock
extends LocationIntPacket {
    private final Direction side;
    private final InteractionHand hand;
    private final int entityID;

    public PacketModWrenchBlock(BlockPos pos, Direction side, InteractionHand hand) {
        super(pos);
        this.side = side;
        this.hand = hand;
        this.entityID = -1;
    }

    public PacketModWrenchBlock(BlockPos pos, InteractionHand hand, int entityID) {
        super(pos);
        this.side = null;
        this.hand = hand;
        this.entityID = entityID;
    }

    public PacketModWrenchBlock(FriendlyByteBuf buffer) {
        super(buffer);
        this.hand = InteractionHand.values()[buffer.readByte()];
        if (buffer.readBoolean()) {
            this.entityID = buffer.readInt();
            this.side = null;
        } else {
            this.side = Direction.values()[buffer.readByte()];
            this.entityID = -1;
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.hand.ordinal());
        if (this.entityID >= 0) {
            buf.writeBoolean(true);
            buf.writeInt(this.entityID);
        } else {
            buf.writeBoolean(false);
            buf.writeByte(this.side.m_122411_());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.f_19853_.isAreaLoaded(this.pos, 0) && PneumaticCraftUtils.canPlayerReach((Player)player, this.pos) && ModdedWrenchUtils.getInstance().isModdedWrench(player.m_21120_(this.hand))) {
                BlockState state;
                if (this.entityID >= 0) {
                    Entity e = player.f_19853_.m_6815_(this.entityID);
                    if (e instanceof IPneumaticWrenchable && e.m_6084_()) {
                        ((IPneumaticWrenchable)e).onWrenched(player.f_19853_, (Player)player, this.pos, this.side, this.hand);
                    }
                } else if (this.side != null && (state = player.f_19853_.m_8055_(this.pos)).m_60734_() instanceof IPneumaticWrenchable) {
                    ((IPneumaticWrenchable)state.m_60734_()).onWrenched(player.f_19853_, (Player)player, this.pos, this.side, this.hand);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

