/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StandardGunAmmoItem
extends AbstractGunAmmoItem {
    private static final String NBT_POTION = "potion";

    @Override
    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().minigun.standardAmmoCartridgeSize.get();
    }

    @Nonnull
    public static ItemStack getPotion(ItemStack ammo) {
        if (ammo.m_41783_() != null && ammo.m_41783_().m_128441_(NBT_POTION)) {
            return ItemStack.m_41712_((CompoundTag)ammo.m_41783_().m_128469_(NBT_POTION));
        }
        return ItemStack.f_41583_;
    }

    public static void setPotion(ItemStack ammo, ItemStack potion) {
        CompoundTag tag = new CompoundTag();
        potion.m_41739_(tag);
        NBTUtils.setCompoundTag(ammo, NBT_POTION, (Tag)tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return stack.m_41793_() || stack.m_41782_() && stack.m_41783_().m_128441_(NBT_POTION);
    }

    @Override
    public int getAmmoCost(ItemStack ammoStack) {
        ItemStack potion = StandardGunAmmoItem.getPotion(ammoStack);
        return potion.m_41619_() ? 1 : StandardGunAmmoItem.getPotionAmmoCost(potion.m_41720_());
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 0xFFFF00;
    }

    @Override
    public float getAirUsageMultiplier(Minigun minigun, ItemStack ammoStack) {
        if (minigun.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0 && !StandardGunAmmoItem.getPotion(ammoStack).m_41619_()) {
            return (float)minigun.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) + 1.0f;
        }
        return 1.0f;
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> infoList, TooltipFlag extraInfo) {
        super.m_7373_(stack, world, infoList, extraInfo);
        ItemStack potion = StandardGunAmmoItem.getPotion(stack);
        if (!potion.m_41619_()) {
            ArrayList potionInfo = new ArrayList();
            potion.m_41720_().m_7373_(potion, world, potionInfo, extraInfo);
            Object extra = "";
            if (potion.m_41720_() instanceof SplashPotionItem) {
                extra = " " + I18n.m_118938_((String)"pneumaticcraft.gui.tooltip.gunAmmo.splash", (Object[])new Object[0]);
            } else if (potion.m_41720_() instanceof LingeringPotionItem) {
                extra = " " + I18n.m_118938_((String)"pneumaticcraft.gui.tooltip.gunAmmo.lingering", (Object[])new Object[0]);
            }
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo", new Object[0]).m_130946_(" ").m_7220_((Component)potionInfo.get(0)).m_130946_((String)extra));
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.combineWithPotion", new Object[0]));
        }
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        ItemStack potion = StandardGunAmmoItem.getPotion(ammo);
        if (!potion.m_41619_() && target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            Player shooter = minigun.getPlayer();
            if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.potionProcChance.get(), 0.25f)) {
                if (potion.m_41720_() == Items.f_42589_) {
                    List effects = PotionUtils.m_43547_((ItemStack)potion);
                    for (MobEffectInstance effect : effects) {
                        entity.m_7292_(new MobEffectInstance(effect));
                    }
                    entity.f_19853_.m_5594_(null, entity.m_142538_(), SoundEvents.f_12436_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else if (potion.m_41720_() == Items.f_42736_ || potion.m_41720_() == Items.f_42739_) {
                    ThrownPotion entityPotion = new ThrownPotion(shooter.f_19853_, (LivingEntity)shooter);
                    entityPotion.m_37446_(potion);
                    entityPotion.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    shooter.f_19853_.m_7967_((Entity)entityPotion);
                }
            }
            return StandardGunAmmoItem.getPotionAmmoCost(potion.m_41720_());
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockHitResult brtr) {
        ItemStack potion = StandardGunAmmoItem.getPotion(ammo);
        if (potion.m_41720_() == Items.f_42736_ || potion.m_41720_() == Items.f_42739_) {
            Player shooter = minigun.getPlayer();
            int chance = (Integer)ConfigHelper.common().minigun.potionProcChance.get() + minigun.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) * 2;
            if (shooter.f_19853_.f_46441_.nextInt(100) < chance) {
                ThrownPotion entityPotion = new ThrownPotion(shooter.f_19853_, (LivingEntity)shooter);
                entityPotion.m_37446_(potion);
                BlockPos pos2 = brtr.m_82425_().m_142300_(brtr.m_82434_());
                entityPotion.m_6034_((double)pos2.m_123341_() + 0.5, (double)pos2.m_123342_() + 0.5, (double)pos2.m_123343_() + 0.5);
                shooter.f_19853_.m_7967_((Entity)entityPotion);
            }
            return StandardGunAmmoItem.getPotionAmmoCost(potion.m_41720_());
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }

    private static int getPotionAmmoCost(Item item) {
        if (item == Items.f_42739_) {
            return 6;
        }
        if (item == Items.f_42736_) {
            return 3;
        }
        if (item == Items.f_42589_) {
            return 1;
        }
        throw new IllegalArgumentException("Item " + item + " is not a potion!");
    }
}

