/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IUpgradeItem;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UpgradeItem
extends Item
implements IUpgradeItem {
    public static final String NBT_DIRECTION = "Facing";
    private final Supplier<PNCUpgrade> upgrade;
    private final int tier;

    public UpgradeItem(Supplier<PNCUpgrade> upgrade, int tier) {
        this(upgrade, tier, ModItems.defaultProps());
    }

    public UpgradeItem(Supplier<PNCUpgrade> upgrade, int tier, Item.Properties properties) {
        super(properties);
        this.upgrade = upgrade;
        this.tier = tier;
    }

    @Override
    public PNCUpgrade getUpgradeType() {
        return this.upgrade.get();
    }

    @Override
    public int getUpgradeTier() {
        return this.tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> infoList, TooltipFlag par4) {
        if (ClientUtils.hasShiftDown()) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.upgrade.usedIn", new Object[0]).m_130940_(ChatFormatting.AQUA));
            PneumaticRegistry.getInstance().getUpgradeRegistry().addUpgradeTooltip(this.upgrade.get(), infoList);
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.upgrade.shiftMessage", new Object[0]).m_130940_(ChatFormatting.AQUA));
        }
        if (this.getUpgradeType() == ModUpgrades.DISPENSER.get()) {
            Direction dir = stack.m_41782_() ? Direction.m_122402_((String)NBTUtils.getString(stack, NBT_DIRECTION)) : null;
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.dispenser.direction", dir == null ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.any", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.direction." + dir.m_7912_(), new Object[0])));
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.dispenser.clickToSet", new Object[0]));
        }
        super.m_7373_(stack, world, infoList, par4);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this.getUpgradeType() == ModUpgrades.DISPENSER.get()) {
            Player player = context.m_43723_();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                this.setDirection(sp, context.m_43724_(), context.m_43719_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (this.getUpgradeType() == ModUpgrades.DISPENSER.get()) {
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)playerIn;
                this.setDirection(sp, handIn, null);
            }
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    private void setDirection(ServerPlayer player, InteractionHand hand, Direction facing) {
        ItemStack stack = player.m_21120_(hand);
        if (facing == null) {
            stack.m_41751_(null);
            player.m_5661_((Component)new TranslatableComponent("pneumaticcraft.message.dispenser.direction", new Object[]{"*"}), true);
        } else {
            NBTUtils.setString(stack, NBT_DIRECTION, facing.m_7912_());
            player.m_5661_((Component)new TranslatableComponent("pneumaticcraft.message.dispenser.direction", new Object[]{facing.m_7912_()}), true);
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.getUpgradeType() == ModUpgrades.CREATIVE.get() ? Rarity.EPIC : Rarity.COMMON;
    }

    public static UpgradeItem of(ItemStack stack) {
        return (UpgradeItem)stack.m_41720_();
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) && this.upgrade.get().isDependencyLoaded()) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }
}

