/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;

public class TagFilterItem
extends Item
implements IFilteringItem {
    private static final String NBT_TAG_LIST = "TagList";

    public TagFilterItem() {
        super(ModItems.defaultProps().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (worldIn != null) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.tag_filter.header", new Object[0]).m_130940_(ChatFormatting.YELLOW));
            for (TagKey<Item> key : TagFilterItem.getConfiguredTagList(stack)) {
                tooltip.add((Component)Symbols.bullet().m_130946_(key.f_203868_().toString()).m_130940_(ChatFormatting.GOLD));
            }
        }
    }

    public static Set<TagKey<Item>> getConfiguredTagList(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(NBT_TAG_LIST)) {
            ListTag l = nbt.m_128437_(NBT_TAG_LIST, 8);
            HashSet<TagKey<Item>> res = new HashSet<TagKey<Item>>();
            for (int i = 0; i < l.size(); ++i) {
                res.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(l.m_128778_(i))));
            }
            return res;
        }
        return Sets.newHashSet();
    }

    public static void setConfiguredTagList(ItemStack stack, Set<TagKey<Item>> tags) {
        ListTag l = new ListTag();
        tags.forEach(tagKey -> l.add((Object)StringTag.m_129297_((String)tagKey.f_203868_().toString())));
        stack.m_41784_().m_128365_(NBT_TAG_LIST, (Tag)l);
    }

    @Override
    public boolean matchFilter(ItemStack filterStack, ItemStack stack) {
        Validate.isTrue((boolean)(filterStack.m_41720_() instanceof TagFilterItem), (String)"filtering itemstack is not a tag filter!", (Object[])new Object[0]);
        Set<TagKey<Item>> tags = TagFilterItem.getConfiguredTagList(filterStack);
        return !Sets.intersection(tags, PneumaticCraftUtils.itemTags(stack.m_41720_())).isEmpty();
    }
}

