/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerCoreItem
extends Item
implements ColorHandlers.ITintableItem {
    private static final String NBT_SPAWNER_CORE = "pneumaticcraft:SpawnerCoreStats";

    public SpawnerCoreItem() {
        super(ModItems.defaultProps());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        SpawnerCoreStats stats = SpawnerCoreStats.forItemStack(stack);
        if (stats != null) {
            if (stats.getUnusedPercentage() < 100) {
                stats.getEntities().stream().sorted(Comparator.comparing(t -> I18n.m_118938_((String)t.m_20675_(), (Object[])new Object[0]))).forEach(type -> tooltip.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate(type.m_20675_(), new Object[0]).m_130940_(ChatFormatting.YELLOW)).m_130946_(": " + stats.getPercentage((EntityType<?>)type) + "%").m_130940_(ChatFormatting.WHITE)));
                if (stats.getUnusedPercentage() > 0) {
                    tooltip.add((Component)Symbols.bullet().m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})).m_130946_(": " + stats.getUnusedPercentage() + "%").m_130940_(ChatFormatting.WHITE));
                }
            } else {
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().f_46443_) {
            return this.trySpawnEntity(context) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean trySpawnEntity(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        if (stack.m_41613_() != 1) {
            return false;
        }
        SpawnerCoreStats stats = SpawnerCoreStats.forItemStack(stack);
        if (stats != null) {
            Vec3 vec;
            Level world = context.m_43725_();
            EntityType<?> type = stats.pickEntity(false);
            if (type != null && type.getRegistryName() != null && world.m_45772_(type.m_20585_((vec = context.m_43720_()).m_7096_(), vec.m_7098_(), vec.m_7094_()))) {
                ServerLevel serverworld = (ServerLevel)world;
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("id", type.getRegistryName().toString());
                Entity entity = EntityType.m_20645_((CompoundTag)nbt, (Level)world, e1 -> {
                    e1.m_7678_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), e1.m_146908_(), e1.m_146909_());
                    return e1;
                });
                if (entity != null) {
                    entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), world.f_46441_.nextFloat() * 360.0f, 0.0f);
                    if (serverworld.m_8860_(entity)) {
                        stats.addAmount(type, -1);
                        stats.serialize(stack);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        SpawnerCoreStats stats;
        if (tintIndex == 1 && (stats = SpawnerCoreStats.forItemStack(stack)) != null) {
            if (stats.getUnusedPercentage() == 100) {
                return -1;
            }
            int t = (int)(ClientUtils.getClientLevel().m_46467_() % 40L);
            float b = t < 20 ? Mth.m_14031_((float)((float)Math.PI * (float)t / 20.0f)) / 6.0f : 0.0f;
            return TintColor.HSBtoRGB(0.19722222f, 1.0f - (float)stats.getUnusedPercentage() / 100.0f, 0.83333f + b);
        }
        return -1;
    }

    public static class SpawnerCoreStats
    implements ISpawnerCoreStats {
        private final Map<EntityType<?>, Integer> entityCounts = new HashMap();
        private int unused;

        private SpawnerCoreStats(ItemStack stack) {
            CompoundTag nbt0 = stack.m_41783_();
            int total = 0;
            if (nbt0 != null && nbt0.m_128441_(SpawnerCoreItem.NBT_SPAWNER_CORE)) {
                CompoundTag nbt = nbt0.m_128469_(SpawnerCoreItem.NBT_SPAWNER_CORE);
                for (String k : nbt.m_128431_()) {
                    EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(k));
                    if (type == null) continue;
                    int amount = nbt.m_128451_(k);
                    this.entityCounts.put(type, amount);
                    total += amount;
                }
            }
            this.unused = Math.max(0, 100 - total);
        }

        static SpawnerCoreStats forItemStack(ItemStack stack) {
            return stack.m_41720_() instanceof SpawnerCoreItem ? new SpawnerCoreStats(stack) : null;
        }

        @Override
        public void serialize(ItemStack stack) {
            if (stack.m_41720_() instanceof SpawnerCoreItem) {
                if (this.unused == 100) {
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_(SpawnerCoreItem.NBT_SPAWNER_CORE);
                    }
                } else {
                    CompoundTag subTag = stack.m_41698_(SpawnerCoreItem.NBT_SPAWNER_CORE);
                    this.entityCounts.forEach((type, amount) -> {
                        if (type.getRegistryName() != null) {
                            if (amount > 0) {
                                subTag.m_128405_(type.getRegistryName().toString(), amount.intValue());
                            } else {
                                subTag.m_128473_(type.getRegistryName().toString());
                            }
                        }
                    });
                }
            } else {
                throw new IllegalArgumentException("item is not a spawner core!");
            }
        }

        @Override
        public Set<EntityType<?>> getEntities() {
            return this.entityCounts.keySet();
        }

        @Override
        public int getPercentage(EntityType<?> entityType) {
            return this.entityCounts.getOrDefault(entityType, 0);
        }

        @Override
        public int getUnusedPercentage() {
            return this.unused;
        }

        @Override
        public boolean addAmount(EntityType<?> type, int toAdd) {
            int current = this.entityCounts.getOrDefault(type, 0);
            if ((toAdd = Mth.m_14045_((int)toAdd, (int)(-current), (int)this.unused)) != 0) {
                int newAmount = Mth.m_14045_((int)(current + toAdd), (int)0, (int)100);
                this.entityCounts.put(type, newAmount);
                this.unused -= toAdd;
                return true;
            }
            return false;
        }

        @Override
        public EntityType<?> pickEntity(boolean includeUnused) {
            if (this.unused == 100) {
                return null;
            }
            ArrayList<WeightedEntity> weightedEntities = new ArrayList<WeightedEntity>();
            this.entityCounts.forEach((type, amount) -> weightedEntities.add(new WeightedEntity((EntityType<?>)type, (int)amount)));
            if (includeUnused) {
                weightedEntities.add(new WeightedEntity(null, this.unused));
            }
            return WeightedRandom.m_146317_((Random)ThreadLocalRandom.current(), weightedEntities).map(WeightedEntity::type).orElse(null);
        }

        private record WeightedEntity(EntityType<?> type, int weight) implements WeightedEntry
        {
            public Weight m_142631_() {
                return Weight.m_146282_((int)this.weight);
            }
        }
    }

    public static class SpawnerCoreItemHandler
    extends BaseItemStackHandler {
        private ISpawnerCoreStats stats;

        public SpawnerCoreItemHandler(BlockEntity owner) {
            super(owner, 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() instanceof SpawnerCoreItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                this.readSpawnerCoreStats();
            }
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.readSpawnerCoreStats();
        }

        public ISpawnerCoreStats getStats() {
            return this.stats;
        }

        private void readSpawnerCoreStats() {
            this.stats = this.getStackInSlot(0).m_41619_() ? null : SpawnerCoreStats.forItemStack(this.getStackInSlot(0));
        }
    }
}

