/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.block.entity.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DroneItem
extends PressurizableItem
implements IChargeableContainerProvider,
IProgrammable,
ColorHandlers.ITintableItem {
    private final BiFunction<Level, Player, DroneEntity> droneCreator;
    private final boolean programmable;
    private final DyeColor defaultColor;

    public DroneItem(BiFunction<Level, Player, DroneEntity> droneCreator, boolean programmable, DyeColor defaultColor) {
        super(ModItems.defaultProps(), 120000, 12000);
        this.droneCreator = droneCreator;
        this.programmable = programmable;
        this.defaultColor = defaultColor;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (world instanceof ServerLevelAccessor) {
            BlockState state;
            ItemStack iStack = ctx.m_43723_().m_21120_(ctx.m_43724_());
            if (iStack.m_41720_() == ModItems.LOGISTICS_DRONE.get()) {
                AdvancementTriggers.LOGISTICS_DRONE_DEPLOYED.trigger((ServerPlayer)ctx.m_43723_());
            }
            BlockPos placePos = (state = world.m_8055_(pos)).m_60812_((BlockGetter)world, pos).m_83281_() ? pos : pos.m_142300_(ctx.m_43719_());
            this.spawnDrone(ctx.m_43723_(), world, pos, ctx.m_43719_(), placePos, iStack);
            iStack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.m_20193_().f_46443_ && stack.m_41782_() && stack.m_41783_().m_128441_("pneumaticcraft:progWidgets")) {
            entity.m_32064_();
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Tank")) {
            FluidTank fluidTank = new FluidTank(16000);
            fluidTank.readFromNBT(stack.m_41783_().m_128469_("Tank"));
            FluidStack fluidStack = fluidTank.getFluid();
            if (!fluidStack.isEmpty()) {
                tooltip.add((Component)new TranslatableComponent("pneumaticcraft.gui.tooltip.fluid").m_130946_(fluidStack.getAmount() + "mB ").m_7220_(fluidStack.getDisplayName()).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public DyeColor getDroneColor(ItemStack stack) {
        return stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("color") ? DyeColor.m_41053_((int)stack.m_41783_().m_128451_("color")) : this.defaultColor;
    }

    public void spawnDrone(Player player, Level world, BlockPos clickPos, Direction facing, BlockPos placePos, ItemStack iStack) {
        DroneEntity drone = this.droneCreator.apply(world, player);
        drone.m_6034_((double)placePos.m_123341_() + 0.5, (double)placePos.m_123342_() + 0.5, (double)placePos.m_123343_() + 0.5);
        drone.readFromItemStack(iStack);
        world.m_7967_((Entity)drone);
        drone.setDeployPos(placePos);
        if (drone.addProgram(clickPos, facing, placePos, iStack, drone.progWidgets)) {
            ProgrammerBlockEntity.updatePuzzleConnections(drone.progWidgets);
        }
        if (world instanceof ServerLevelAccessor) {
            drone.m_6518_((ServerLevelAccessor)world, world.m_6436_(placePos), MobSpawnType.TRIGGERED, new SpawnGroupData(){}, null);
        }
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return this.programmable;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return true;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, (MenuType<? extends ChargingStationUpgradeManagerMenu>)((MenuType)ModMenuTypes.CHARGING_DRONE.get()));
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return tintIndex == 1 ? PneumaticCraftUtils.getDyeColorAsRGB(this.getDroneColor(stack)) : -1;
    }
}

