/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.heat.HeatRegistrationEvent;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.recipes.other.HeatPropertiesRecipeImpl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public enum BlockHeatProperties implements Iterable<HeatPropertiesRecipe>
{
    INSTANCE;

    private final ArrayListMultimap<Block, HeatPropertiesRecipe> customHeatEntries = ArrayListMultimap.create();

    public static BlockHeatProperties getInstance() {
        return INSTANCE;
    }

    public HeatPropertiesRecipe getCustomHeatEntry(Level world, BlockState state) {
        if (this.customHeatEntries.isEmpty()) {
            this.populateCustomHeatEntries(world);
        }
        return this.customHeatEntries.get((Object)state.m_60734_()).stream().filter(entry -> entry.matchState(state)).findFirst().orElse(null);
    }

    public Collection<HeatPropertiesRecipe> getAllEntries(Level world) {
        if (this.customHeatEntries.isEmpty()) {
            this.populateCustomHeatEntries(world);
        }
        return this.customHeatEntries.values();
    }

    public void clear() {
        this.customHeatEntries.clear();
    }

    public void register(Block block, HeatPropertiesRecipe entry) {
        this.customHeatEntries.put((Object)block, (Object)entry);
    }

    private void populateCustomHeatEntries(Level world) {
        ModRecipeTypes.getRecipes(world, ModRecipeTypes.BLOCK_HEAT_PROPERTIES).forEach(recipe -> this.customHeatEntries.put((Object)recipe.getBlock(), recipe));
        MinecraftForge.EVENT_BUS.post((Event)new HeatRegistrationEvent(HeatExchangerManager.getInstance()));
        this.registerDefaultFluidValues();
    }

    private void registerDefaultFluidValues() {
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            List entry;
            Block block;
            if (fluid == Fluids.f_76191_ || !((Boolean)ConfigHelper.common().heat.addDefaultFluidEntries.get()).booleanValue() && !fluid.getRegistryName().m_135827_().equals("minecraft") || !((block = fluid.m_76145_().m_76188_().m_60734_()) instanceof LiquidBlock) || this.customHeatEntries.containsKey((Object)block) || !(entry = this.customHeatEntries.get((Object)block)).isEmpty()) continue;
            this.customHeatEntries.put((Object)block, (Object)this.buildDefaultFluidEntry(block, fluid));
        }
    }

    private HeatPropertiesRecipe buildDefaultFluidEntry(Block block, Fluid fluid) {
        BlockState transformColdFlowing;
        BlockState transformCold;
        BlockState transformHotFlowing;
        BlockState transformHot;
        int temperature = fluid.getAttributes().getTemperature();
        if (temperature >= Fluids.f_76195_.getAttributes().getTemperature()) {
            transformHot = null;
            transformHotFlowing = null;
            transformCold = Blocks.f_50080_.m_49966_();
            transformColdFlowing = Blocks.f_50652_.m_49966_();
        } else if (temperature <= 273) {
            transformHot = Blocks.f_50127_.m_49966_();
            transformHotFlowing = Blocks.f_50125_.m_49966_();
            transformCold = Blocks.f_50568_.m_49966_();
            transformColdFlowing = Blocks.f_50125_.m_49966_();
        } else {
            transformHot = Blocks.f_50016_.m_49966_();
            transformHotFlowing = Blocks.f_50016_.m_49966_();
            transformCold = Blocks.f_50126_.m_49966_();
            transformColdFlowing = Blocks.f_50125_.m_49966_();
        }
        return new HeatPropertiesRecipeImpl(block.getRegistryName(), block, transformHot, transformHotFlowing, transformCold, transformColdFlowing, (Integer)ConfigHelper.common().heat.defaultFluidHeatCapacity.get(), temperature, (Double)ConfigHelper.common().heat.fluidThermalResistance.get(), Collections.emptyMap(), "");
    }

    @Override
    public Iterator<HeatPropertiesRecipe> iterator() {
        return this.customHeatEntries.values().iterator();
    }
}

