/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.Reflections;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;

public class HackableBlaze
implements IHackableEntity {
    private static final ResourceLocation ID = PneumaticRegistry.RL("blaze");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    public boolean canHack(Entity entity, Player player) {
        return Reflections.blaze_aiFireballAttack != null;
    }

    @Override
    public void addHackInfo(Entity entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.disarm", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Entity entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.disarmed", new Object[0]));
    }

    @Override
    public int getHackTime(Entity entity, Player player) {
        return 60;
    }

    @Override
    public void onHackFinished(Entity entity, Player player) {
        GoalSelector tasks = ((Blaze)entity).f_21345_;
        tasks.m_25386_().filter(goal -> Reflections.blaze_aiFireballAttack.isAssignableFrom(goal.getClass())).forEach(arg_0 -> ((GoalSelector)tasks).m_25363_(arg_0));
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return false;
    }
}

