/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.hacking.block.HackableButton;
import me.desht.pneumaticcraft.common.hacking.block.HackableDispenser;
import me.desht.pneumaticcraft.common.hacking.block.HackableDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableJukebox;
import me.desht.pneumaticcraft.common.hacking.block.HackableLever;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.hacking.block.HackableNoteblock;
import me.desht.pneumaticcraft.common.hacking.block.HackableSecurityStation;
import me.desht.pneumaticcraft.common.hacking.block.HackableSilverfish;
import me.desht.pneumaticcraft.common.hacking.block.HackableTNT;
import me.desht.pneumaticcraft.common.hacking.block.HackableTrapDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableTripwire;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBat;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBlaze;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCaveSpider;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCow;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCreeper;
import me.desht.pneumaticcraft.common.hacking.entity.HackableEnderman;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGhast;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGuardian;
import me.desht.pneumaticcraft.common.hacking.entity.HackableHorse;
import me.desht.pneumaticcraft.common.hacking.entity.HackableItemFrame;
import me.desht.pneumaticcraft.common.hacking.entity.HackableMobDisarm;
import me.desht.pneumaticcraft.common.hacking.entity.HackablePainting;
import me.desht.pneumaticcraft.common.hacking.entity.HackablePufferfish;
import me.desht.pneumaticcraft.common.hacking.entity.HackableSheep;
import me.desht.pneumaticcraft.common.hacking.entity.HackableShulker;
import me.desht.pneumaticcraft.common.hacking.entity.HackableSquid;
import me.desht.pneumaticcraft.common.hacking.entity.HackableTameable;
import me.desht.pneumaticcraft.common.hacking.entity.HackableVillager;
import me.desht.pneumaticcraft.common.hacking.entity.HackableWitch;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.tuple.Pair;

public class HackManager {
    private static HackManager clientInstance;
    private static HackManager serverInstance;
    private final Map<Entity, IHackableEntity> trackedHackableEntities = new HashMap<Entity, IHackableEntity>();
    private final Map<WorldAndCoord, Pair<Block, IHackableBlock>> trackedHackableBlocks = new HashMap<WorldAndCoord, Pair<Block, IHackableBlock>>();
    private long lastEntityPrune = 0L;
    private long lastBlockPrune = 0L;

    private static HackManager getInstance(Level world) {
        if (world.f_46443_) {
            if (clientInstance == null) {
                clientInstance = new HackManager();
            }
            return clientInstance;
        }
        if (serverInstance == null) {
            serverInstance = new HackManager();
        }
        return serverInstance;
    }

    public static void addDefaultEntries() {
        ICommonArmorRegistry registry = PneumaticRegistry.getInstance().getCommonArmorRegistry();
        registry.addHackable(Blocks.f_50077_, HackableTNT::new);
        registry.addHackable(Blocks.f_50085_, HackableMobSpawner::new);
        registry.addHackable(Blocks.f_50164_, HackableLever::new);
        registry.addHackable(Blocks.f_50266_, HackableTripwire::new);
        registry.addHackable(Blocks.f_50061_, HackableDispenser::new);
        registry.addHackable(Blocks.f_50286_, HackableDispenser::new);
        registry.addHackable((Block)ModBlocks.SECURITY_STATION.get(), HackableSecurityStation::new);
        registry.addHackable(Blocks.f_50227_, HackableSilverfish::new);
        registry.addHackable(Blocks.f_50179_, HackableSilverfish::new);
        registry.addHackable(Blocks.f_50178_, HackableSilverfish::new);
        registry.addHackable(Blocks.f_50177_, HackableSilverfish::new);
        registry.addHackable(Blocks.f_50226_, HackableSilverfish::new);
        registry.addHackable(Blocks.f_50176_, HackableSilverfish::new);
        registry.addHackable(Blocks.f_50065_, HackableNoteblock::new);
        registry.addHackable(Blocks.f_50131_, HackableJukebox::new);
        registry.addHackable((TagKey<Block>)BlockTags.f_13093_, HackableButton::new);
        registry.addHackable((TagKey<Block>)BlockTags.f_13103_, HackableDoor::new);
        registry.addHackable((TagKey<Block>)BlockTags.f_13036_, HackableTrapDoor::new);
        registry.addHackable(Mob.class, HackableMobDisarm::new);
        registry.addHackable(Creeper.class, HackableCreeper::new);
        registry.addHackable(TamableAnimal.class, HackableTameable::new);
        registry.addHackable(Cow.class, HackableCow::new);
        registry.addHackable(Sheep.class, HackableSheep::new);
        registry.addHackable(CaveSpider.class, HackableCaveSpider::new);
        registry.addHackable(Blaze.class, HackableBlaze::new);
        registry.addHackable(Ghast.class, HackableGhast::new);
        registry.addHackable(Witch.class, HackableWitch::new);
        registry.addHackable(EnderMan.class, HackableEnderman::new);
        registry.addHackable(Bat.class, HackableBat::new);
        registry.addHackable(Horse.class, HackableHorse::new);
        registry.addHackable(Shulker.class, HackableShulker::new);
        registry.addHackable(Guardian.class, HackableGuardian::new);
        registry.addHackable(Pufferfish.class, HackablePufferfish::new);
        registry.addHackable(Squid.class, HackableSquid::new);
        registry.addHackable(Villager.class, HackableVillager::new);
        registry.addHackable(Painting.class, HackablePainting::new);
        registry.addHackable(ItemFrame.class, HackableItemFrame::new);
    }

    public static IHackableEntity getHackableForEntity(Entity entity, Player player) {
        IHackableEntity h;
        HackManager manager = HackManager.getInstance(player.m_183503_());
        if (player.m_183503_().m_46467_() - 60L > manager.lastEntityPrune) {
            manager.trackedHackableEntities.entrySet().removeIf(entry -> !((Entity)entry.getKey()).m_6084_() || !((IHackableEntity)entry.getValue()).canHack((Entity)entry.getKey(), player) && !HackManager.isInDisplayCooldown((IHackableEntity)entry.getValue(), (Entity)entry.getKey()));
            manager.lastEntityPrune = player.m_183503_().m_46467_();
        }
        if (entity instanceof IHackableEntity && (h = (IHackableEntity)entity).canHack(entity, player)) {
            return h;
        }
        IHackableEntity hackable = manager.trackedHackableEntities.get(entity);
        if (hackable == null && (hackable = CommonArmorRegistry.getInstance().getHackable(entity, player)) != null) {
            manager.trackedHackableEntities.put(entity, hackable);
        }
        return hackable;
    }

    public static IHackableBlock getHackableForBlock(BlockGetter world, BlockPos pos, Player player) {
        IHackableBlock h;
        Block block = world.m_8055_(pos).m_60734_();
        HackManager manager = HackManager.getInstance(player.m_183503_());
        if (player.m_183503_().m_46467_() - 60L > manager.lastBlockPrune) {
            manager.trackedHackableBlocks.entrySet().removeIf(entry -> {
                Block trackedBlock = (Block)((Pair)entry.getValue()).getLeft();
                IHackableBlock hackableBlock = (IHackableBlock)((Pair)entry.getValue()).getRight();
                return block != trackedBlock || !hackableBlock.canHack(((WorldAndCoord)entry.getKey()).world, ((WorldAndCoord)entry.getKey()).pos, player) && !HackManager.isInDisplayCooldown(hackableBlock, ((WorldAndCoord)entry.getKey()).world, ((WorldAndCoord)entry.getKey()).pos, player);
            });
            manager.lastBlockPrune = player.m_183503_().m_46467_();
        }
        if (block instanceof IHackableBlock && (h = (IHackableBlock)block).canHack(world, pos, player)) {
            return h;
        }
        WorldAndCoord loc = new WorldAndCoord(world, pos);
        Pair pair = manager.trackedHackableBlocks.get(loc);
        if (pair == null) {
            IHackableBlock hackable = CommonArmorRegistry.getInstance().getHackable(block);
            if (hackable != null && hackable.canHack(world, pos, player)) {
                pair = Pair.of((Object)block, (Object)hackable);
                manager.trackedHackableBlocks.put(loc, (Pair<Block, IHackableBlock>)pair);
            } else {
                return null;
            }
        }
        return (IHackableBlock)pair.getRight();
    }

    private static boolean isInDisplayCooldown(IHackableBlock hackableBlock, BlockGetter world, BlockPos pos, Player player) {
        if (player.f_19853_.f_46443_) {
            RenderBlockTarget target = ArmorUpgradeClientRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class).getTargetForCoord(pos);
            int requiredHackTime = hackableBlock.getHackTime(world, pos, player);
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    private static boolean isInDisplayCooldown(IHackableEntity hackableEntity, Entity entity) {
        if (entity.f_19853_.f_46443_) {
            RenderEntityTarget target = ArmorUpgradeClientRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).getTargetForEntity(entity);
            int requiredHackTime = hackableEntity.getHackTime(entity, ClientUtils.getClientPlayer());
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }
}

