/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCropLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCrops;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerLeaves;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerTree;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class ModHarvestHandlers {
    public static final DeferredRegister<HarvestHandler> HARVEST_HANDLERS_DEFERRED = DeferredRegister.create((ResourceLocation)PneumaticRegistry.RL("harvest_handlers"), (String)"pneumaticcraft");
    public static final Supplier<IForgeRegistry<HarvestHandler>> HARVEST_HANDLERS = HARVEST_HANDLERS_DEFERRED.makeRegistry(HarvestHandler.class, () -> new RegistryBuilder().disableSaving().disableSync());
    public static final RegistryObject<HarvestHandler> CROPS = ModHarvestHandlers.register("crops", HarvestHandlerCrops::new);
    public static final RegistryObject<HarvestHandler> NETHER_WART = ModHarvestHandlers.register("nether_wart", () -> new HarvestHandlerCropLike(state -> state.m_60734_() == Blocks.f_50200_, NetherWartBlock.f_54967_, stack -> stack.m_41720_() == Items.f_42588_));
    public static final RegistryObject<HarvestHandler> SWEET_BERRIES = ModHarvestHandlers.register("sweet_berries", () -> new HarvestHandlerCropLike(state -> state.m_60734_() == Blocks.f_50685_, SweetBerryBushBlock.f_57244_, stack -> stack.m_41720_() == Items.f_42780_){

        @Override
        protected BlockState withMinAge(BlockState state) {
            return (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));
        }
    });
    public static final RegistryObject<HarvestHandler> COCOA = ModHarvestHandlers.register("cocoa_beans", () -> new HarvestHandlerCropLike(state -> state.m_60734_() == Blocks.f_50262_, CocoaBlock.f_51736_, stack -> stack.m_41720_() == Items.f_42533_));
    public static final RegistryObject<HarvestHandler> CACTUS = ModHarvestHandlers.register("cactus_like", () -> new HarvestHandlerCactusLike(state -> state.m_60734_() == Blocks.f_50128_ || state.m_60734_() == Blocks.f_50130_ || state.m_60734_() == Blocks.f_50576_));
    public static final RegistryObject<HarvestHandler> PUMPKIN = ModHarvestHandlers.register("pumpkin_like", () -> new HarvestHandler.SimpleHarvestHandler(Blocks.f_50133_, Blocks.f_50186_));
    public static final RegistryObject<HarvestHandler> LEAVES = ModHarvestHandlers.register("leaves", HarvestHandlerLeaves::new);
    public static final RegistryObject<HarvestHandler> TREES = ModHarvestHandlers.register("trees", HarvestHandlerTree::new);

    private static <T extends HarvestHandler> RegistryObject<T> register(String name, Supplier<T> sup) {
        return HARVEST_HANDLERS_DEFERRED.register(name, sup);
    }

    public static enum TreePart {
        LOG("_log"),
        LEAVES("_leaves"),
        SAPLING("_sapling");

        private final String suffix;
        private final Pattern pattern;

        private TreePart(String suffix) {
            this.suffix = suffix;
            this.pattern = Pattern.compile(suffix + "$");
        }

        public Block convert(Block in, TreePart to) {
            ResourceLocation rl0 = in.getRegistryName();
            if (rl0 == null) {
                return Blocks.f_50016_;
            }
            ResourceLocation rl = new ResourceLocation(rl0.m_135827_(), this.pattern.matcher(rl0.m_135815_()).replaceAll(to.suffix));
            return (Block)ForgeRegistries.BLOCKS.getValue(rl);
        }
    }
}

