/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.resources.ResourceLocation;

public class AmadronPlayerOffers
extends AuxConfigJson {
    public static final AmadronPlayerOffers INSTANCE = new AmadronPlayerOffers();
    private static final String DESC = "Stores all the current player-to-player Amadron trades,along with stock information, pending payments etc.";
    private final Map<ResourceLocation, AmadronPlayerOffer> playerOffers = new HashMap<ResourceLocation, AmadronPlayerOffer>();

    private AmadronPlayerOffers() {
        super(false);
    }

    @Override
    public String getConfigFilename() {
        return "AmadronPlayerOffers";
    }

    public Map<ResourceLocation, AmadronPlayerOffer> getPlayerOffers() {
        return this.playerOffers;
    }

    public static void save() {
        INSTANCE.tryWriteToFile();
    }

    @Override
    public void clear() {
        this.playerOffers.clear();
    }

    @Override
    protected void writeToJson(JsonObject json) {
        JsonArray array = new JsonArray();
        for (AmadronPlayerOffer offer : this.playerOffers.values()) {
            array.add((JsonElement)offer.toJson(new JsonObject()));
        }
        json.addProperty("description", DESC);
        json.add("offers", (JsonElement)array);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        JsonArray array = (JsonArray)json.get("offers");
        this.playerOffers.clear();
        for (JsonElement element : array) {
            try {
                AmadronPlayerOffer offer = AmadronPlayerOffer.fromJson((JsonObject)element);
                this.playerOffers.put(offer.m_6423_(), offer);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        AmadronOfferManager.getInstance().addPlayerOffers();
    }

    @Override
    public boolean useWorldSpecificDir() {
        return true;
    }
}

