/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.UVLightBoxBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.UVLightBoxMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.EmptyPCBItem;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class UVLightBoxBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<UVLightBoxBlockEntity>,
MenuProvider {
    private static final String NBT_EXPOSURE = "pneumaticcraft:uv_exposure";
    public static final int INVENTORY_SIZE = 1;
    public static final int PCB_SLOT = 0;
    private static final List<RedstoneController.RedstoneMode<UVLightBoxBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("standard.always", new ItemStack((ItemLike)Items.f_42403_), te -> true), new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.f_42451_), te -> te.getCurrentRedstonePower() > 0), new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("standard.low_signal", new ItemStack((ItemLike)Items.f_41978_), te -> te.getCurrentRedstonePower() == 0), new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("uvLightBox.interpolate", new ItemStack((ItemLike)Items.f_42351_), te -> te.getCurrentRedstonePower() > 0));
    public static final int RS_MODE_INTERPOLATE = 3;
    private long lastStateUpdate = 0L;
    private BlockState pendingState;
    @GuiSynced
    public final RedstoneController<UVLightBoxBlockEntity> rsController = new RedstoneController<UVLightBoxBlockEntity>(this, REDSTONE_MODES);
    @GuiSynced
    public int threshold = 100;
    private final UVInputHandler inputHandler = new UVInputHandler();
    private final ItemStackHandler outputHandler = new BaseItemStackHandler(this, 1);
    private final UVInvWrapper inventoryExt = new UVInvWrapper();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventoryExt);
    private LazyOptional<IItemHandler> cachedEjectHandler = LazyOptional.empty();
    public int ticksExisted;

    public UVLightBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.UV_LIGHT_BOX.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        ++this.ticksExisted;
        ItemStack stack = this.getLoadedPCB();
        boolean didWork = false;
        if (this.rsController.getCurrentMode() == 3) {
            this.threshold = Math.min(100, 25 + this.rsController.getCurrentRedstonePower() * 5);
        }
        if (!stack.m_41619_() && this.rsController.shouldRun()) {
            int progress = UVLightBoxBlockEntity.getExposureProgress(stack);
            if (this.getPressure() >= 1.0f && progress < 100) {
                this.addAir((int)(-2.0f * this.getSpeedUsageMultiplierFromUpgrades()));
                if (this.ticksExisted % this.ticksPerProgress(progress) == 0) {
                    UVLightBoxBlockEntity.setExposureProgress(stack, ++progress);
                }
                if (progress >= this.threshold && this.outputHandler.insertItem(0, this.inputHandler.getStackInSlot(0), true).m_41619_()) {
                    ItemStack toMove = this.inputHandler.extractItem(0, 1, false);
                    this.outputHandler.insertItem(0, toMove, false);
                }
                didWork = true;
            }
        }
        if (this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0) {
            this.tryEject();
        }
        this.checkStateUpdates(stack, didWork);
    }

    private void checkStateUpdates(ItemStack loadedStack, boolean didWork) {
        BlockState state = this.m_58900_();
        if (state.m_60734_() == ModBlocks.UV_LIGHT_BOX.get()) {
            boolean loaded = (Boolean)state.m_61143_((Property)UVLightBoxBlock.LOADED);
            boolean update = false;
            if (loaded == loadedStack.m_41619_()) {
                state = (BlockState)state.m_61124_((Property)UVLightBoxBlock.LOADED, (Comparable)Boolean.valueOf(!loadedStack.m_41619_()));
                update = true;
            }
            if (didWork != (Boolean)this.m_58900_().m_61143_((Property)UVLightBoxBlock.LIT)) {
                state = (BlockState)state.m_61124_((Property)UVLightBoxBlock.LIT, (Comparable)Boolean.valueOf(didWork));
                update = true;
            }
            long now = this.nonNullLevel().m_46467_();
            if (update) {
                if (now - this.lastStateUpdate > 10L) {
                    this.nonNullLevel().m_46597_(this.f_58858_, state);
                    this.pendingState = null;
                    this.lastStateUpdate = now;
                } else {
                    this.pendingState = state;
                }
            } else if (this.pendingState != null && now - this.lastStateUpdate > 10L) {
                this.nonNullLevel().m_46597_(this.f_58858_, this.pendingState);
                this.pendingState = null;
                this.lastStateUpdate = now;
            }
        }
    }

    private void tryEject() {
        Direction dir = this.getUpgradeCache().getEjectDirection();
        if (dir != null) {
            this.getEjectionHandler().ifPresent(handler -> {
                ItemStack stack = this.outputHandler.extractItem(0, 1, true);
                if (!stack.m_41619_() && ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false).m_41619_()) {
                    this.outputHandler.extractItem(0, 1, false);
                }
            });
        }
    }

    private LazyOptional<IItemHandler> getEjectionHandler() {
        if (!this.cachedEjectHandler.isPresent()) {
            Direction dir = this.getUpgradeCache().getEjectDirection();
            BlockEntity te = this.nonNullLevel().m_7702_(this.f_58858_.m_142300_(dir));
            this.cachedEjectHandler = IOHelper.getInventoryForTE(te, dir.m_122424_());
            if (this.cachedEjectHandler.isPresent()) {
                this.cachedEjectHandler.addListener(l -> {
                    this.cachedEjectHandler = LazyOptional.empty();
                });
            }
        }
        return this.cachedEjectHandler;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.threshold = tag.m_128451_("threshold");
        this.inputHandler.deserializeNBT(tag.m_128469_("Items"));
        this.outputHandler.deserializeNBT(tag.m_128469_("Output"));
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("threshold", this.threshold);
        nbt.m_128365_("Items", (Tag)this.inputHandler.serializeNBT());
        nbt.m_128365_("Output", (Tag)this.outputHandler.serializeNBT());
    }

    public static int getExposureProgress(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128451_(NBT_EXPOSURE) : 0;
    }

    public static void setExposureProgress(ItemStack stack, int progress) {
        Validate.isTrue((progress >= 0 && progress <= 100 ? 1 : 0) != 0);
        stack.m_41784_().m_128405_(NBT_EXPOSURE, progress);
    }

    private int ticksPerProgress(int progress) {
        int ticks = progress < 20 ? 20 : (progress < 40 ? 40 : (progress < 60 ? 80 : (progress < 80 ? 160 : 300)));
        return Math.max(1, (int)((float)ticks / this.getSpeedMultiplierFromUpgrades()));
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onDescUpdate() {
        this.nonNullLevel().m_7726_().m_7827_().m_142202_(this.m_58899_());
        super.onDescUpdate();
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.threshold = Mth.m_14045_((int)Integer.parseInt(tag), (int)1, (int)100);
            this.m_6596_();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inputHandler;
    }

    public IItemHandler getOutputInventory() {
        return this.outputHandler;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public RedstoneController<UVLightBoxBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 1.0f;
    }

    private ItemStack getLoadedPCB() {
        return this.inputHandler.getStackInSlot(0);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new UVLightBoxMenu(i, playerInventory, this.m_58899_());
    }

    public int getThreshold() {
        return this.threshold;
    }

    private class UVInputHandler
    extends BaseItemStackHandler {
        UVInputHandler() {
            super(UVLightBoxBlockEntity.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || itemStack.m_41720_() instanceof EmptyPCBItem && EmptyPCBItem.getEtchProgress(itemStack) == 0;
        }
    }

    private class UVInvWrapper
    implements IItemHandler {
        UVInvWrapper() {
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.getStackInSlot(0) : UVLightBoxBlockEntity.this.outputHandler.getStackInSlot(0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.insertItem(0, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 1 ? UVLightBoxBlockEntity.this.outputHandler.extractItem(0, amount, simulate) : ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.getSlotLimit(0) : UVLightBoxBlockEntity.this.outputHandler.getSlotLimit(0);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.isItemValid(0, stack) : UVLightBoxBlockEntity.this.outputHandler.isItemValid(0, stack);
        }
    }
}

