/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.AbstractPressureWallBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberWallBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberValveBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

public class PressureChamberWallBlockEntity
extends AbstractTickingBlockEntity
implements IManoMeasurable,
IInfoForwarder {
    private PressureChamberValveBlockEntity teValve;
    private BlockPos valvePos;

    public PressureChamberWallBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.PRESSURE_CHAMBER_WALL.get()), pos, state, 0);
    }

    PressureChamberWallBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int upgradeSize) {
        super(type, pos, state, upgradeSize);
    }

    public PressureChamberValveBlockEntity getPrimaryValve() {
        if (this.teValve == null && this.valvePos != null) {
            PressureChamberValveBlockEntity v;
            BlockEntity blockEntity = this.nonNullLevel().m_7702_(this.valvePos);
            this.setPrimaryValve(blockEntity instanceof PressureChamberValveBlockEntity ? (v = (PressureChamberValveBlockEntity)blockEntity) : null);
        }
        return this.teValve;
    }

    void setPrimaryValve(PressureChamberValveBlockEntity newValve) {
        boolean valveChanging = this.teValve != newValve || newValve == null && this.valvePos != null || newValve != null && this.valvePos == null;
        BlockPos blockPos = this.valvePos = newValve == null ? null : newValve.m_58899_();
        if (valveChanging && !this.nonNullLevel().f_46443_) {
            this.teValve = newValve;
            PressureWallStateManager.addDeferredUpdate(this, this.teValve);
            this.m_6596_();
        }
    }

    public void onBlockBreak() {
        this.teValve = this.getPrimaryValve();
        if (this.teValve != null) {
            this.teValve.onMultiBlockBreak();
        }
    }

    private void updateBlockState(PressureChamberValveBlockEntity valve) {
        if (!(this.m_58901_() || valve != null && valve.m_58901_() || !this.m_58900_().m_61138_(AbstractPressureWallBlock.WALL_STATE))) {
            this.nonNullLevel().m_7731_(this.m_58899_(), this.calcNewBlockState(valve), 2);
        }
    }

    private BlockState calcNewBlockState(PressureChamberValveBlockEntity valve) {
        PressureChamberWallBlock.WallState wallState = PressureChamberWallBlock.WallState.NONE;
        if (valve != null && !valve.m_58901_()) {
            boolean zMax;
            boolean xMin = this.m_58899_().m_123341_() == valve.multiBlockX;
            boolean yMin = this.m_58899_().m_123342_() == valve.multiBlockY;
            boolean zMin = this.m_58899_().m_123343_() == valve.multiBlockZ;
            boolean xMax = this.m_58899_().m_123341_() == valve.multiBlockX + valve.multiBlockSize - 1;
            boolean yMax = this.m_58899_().m_123342_() == valve.multiBlockY + valve.multiBlockSize - 1;
            boolean bl = zMax = this.m_58899_().m_123343_() == valve.multiBlockZ + valve.multiBlockSize - 1;
            wallState = xMin && yMin && zMin || xMax && yMax && zMax ? PressureChamberWallBlock.WallState.XMIN_YMIN_ZMIN : (xMin && yMin && zMax || xMax && yMax && zMin ? PressureChamberWallBlock.WallState.XMIN_YMIN_ZMAX : (xMin && yMax && zMax || xMax && yMin && zMin ? PressureChamberWallBlock.WallState.XMIN_YMAX_ZMAX : (xMin && yMax && zMin || xMax && yMin && zMax ? PressureChamberWallBlock.WallState.XMIN_YMAX_ZMIN : (yMin && xMin || yMax && xMax || yMin && xMax || yMax && xMin ? PressureChamberWallBlock.WallState.XEDGE : (yMin && zMin || yMax && zMax || yMin && zMax || yMax && zMin ? PressureChamberWallBlock.WallState.ZEDGE : (!yMin && !yMax ? (xMin && zMin || xMax && zMax || xMin && zMax || xMax && zMin ? PressureChamberWallBlock.WallState.YEDGE : PressureChamberWallBlock.WallState.CENTER) : PressureChamberWallBlock.WallState.CENTER))))));
        }
        return (BlockState)this.m_58900_().m_61124_(AbstractPressureWallBlock.WALL_STATE, (Comparable)((Object)wallState));
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.teValve = null;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.valvePos = tag.m_128471_("noValve") ? null : (tag.m_128441_("valvePos") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("valvePos")) : new BlockPos(tag.m_128451_("valveX"), tag.m_128451_("valveY"), tag.m_128451_("valveZ")));
        this.teValve = null;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.valvePos == null) {
            tag.m_128379_("noValve", true);
        } else {
            tag.m_128365_("valvePos", (Tag)NbtUtils.m_129224_((BlockPos)this.valvePos));
        }
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        if (this.getPrimaryValve() != null) {
            this.teValve.airHandler.printManometerMessage(player, curInfo);
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public BlockEntity getInfoBlockEntity() {
        return this.getPrimaryValve();
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class PressureWallStateManager {
        private static final Deque<WallAndValve> todo = new ArrayDeque<WallAndValve>();

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                while (!todo.isEmpty()) {
                    WallAndValve element = todo.poll();
                    element.wall().updateBlockState(element.valve());
                }
            }
        }

        private static void addDeferredUpdate(PressureChamberWallBlockEntity wall, PressureChamberValveBlockEntity valve) {
            todo.offer(new WallAndValve(wall, valve));
        }

        private record WallAndValve(PressureChamberWallBlockEntity wall, PressureChamberValveBlockEntity valve) {
        }
    }
}

