/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlasticBrickBlock
extends Block
implements ColorHandlers.ITintableBlock {
    private static final VoxelShape COLLISION_SHAPE = PlasticBrickBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final EnumProperty<PartType> X_PART = EnumProperty.m_61587_((String)"x_part", PartType.class);
    private static final EnumProperty<PartType> Z_PART = EnumProperty.m_61587_((String)"z_part", PartType.class);
    private final DyeColor dyeColor;
    private final int tintColor;

    public PlasticBrickBlock(DyeColor dyeColor) {
        this(ModBlocks.defaultProps().m_60918_(SoundType.f_56736_).m_60978_(2.0f), dyeColor);
    }

    PlasticBrickBlock(BlockBehaviour.Properties props, DyeColor dyeColor) {
        super(props);
        this.dyeColor = dyeColor;
        this.tintColor = PneumaticCraftUtils.getDyeColorAsRGB(dyeColor);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(X_PART, (Comparable)((Object)PartType.NONE))).m_61124_(Z_PART, (Comparable)((Object)PartType.NONE)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{X_PART, Z_PART});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return this.calcParts((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.calcParts(worldIn, currentPos, stateIn);
    }

    protected boolean hurtsToStepOn() {
        return true;
    }

    private BlockState calcParts(LevelAccessor world, BlockPos pos, BlockState stateIn) {
        boolean zRight;
        boolean xRight;
        Block w = world.m_8055_(pos.m_142125_()).m_60734_();
        Block e = world.m_8055_(pos.m_142126_()).m_60734_();
        PartType xType = PartType.NONE;
        boolean bl = xRight = (pos.m_123341_() + pos.m_123342_() & 1) == 0;
        if (xRight && w == this) {
            xType = PartType.RIGHT;
        } else if (!xRight && e == this) {
            xType = PartType.LEFT;
        }
        Block n = world.m_8055_(pos.m_142127_()).m_60734_();
        Block s = world.m_8055_(pos.m_142128_()).m_60734_();
        PartType zType = PartType.NONE;
        boolean bl2 = zRight = (pos.m_123343_() + pos.m_123342_() & 1) == 0;
        if (zRight && s == this) {
            zType = PartType.RIGHT;
        } else if (!zRight && n == this) {
            zType = PartType.LEFT;
        }
        return (BlockState)((BlockState)stateIn.m_61124_(X_PART, (Comparable)((Object)xType))).m_61124_(Z_PART, (Comparable)((Object)zType));
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity livingEntity;
        ItemStack stack;
        if (this.hurtsToStepOn() && entityIn instanceof LivingEntity && (stack = (livingEntity = (LivingEntity)entityIn).m_6844_(EquipmentSlot.FEET)).m_41619_()) {
            entityIn.m_6469_(DamageSourcePneumaticCraft.PLASTIC_BLOCK, 3.0f);
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
        }
    }

    @Override
    public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        return this.tintColor;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    static enum PartType implements StringRepresentable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private PartType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static class ItemPlasticBrick
    extends BlockItem
    implements ICustomTooltipName {
        public ItemPlasticBrick(PlasticBrickBlock blockPlasticBrick) {
            super((Block)blockPlasticBrick, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return "block.pneumaticcraft.plastic_brick";
        }
    }
}

