/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.misc.IPneumaticCraftProbeable;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractPneumaticCraftBlock
extends Block
implements IPneumaticWrenchable,
IPneumaticCraftProbeable {
    static final VoxelShape ALMOST_FULL_SHAPE = Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty[] CONNECTION_PROPERTIES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};

    protected AbstractPneumaticCraftBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity te = world.m_7702_(pos);
        if (player.m_6144_() || !(te instanceof MenuProvider) || this.isRotatable() && (heldItem.m_41720_() == ModItems.MANOMETER.get() || ModdedWrenchUtils.getInstance().isModdedWrench(heldItem)) || hand == InteractionHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(player.m_21205_())) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (te instanceof AbstractPneumaticCraftBlockEntity) {
                if (FluidUtils.tryFluidInsertion(te, null, player, hand)) {
                    world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (FluidUtils.tryFluidExtraction(te, null, player, hand)) {
                    world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                this.doOpenGui(serverPlayer, te);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void doOpenGui(ServerPlayer player, BlockEntity te) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)te), (BlockPos)te.m_58899_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state != null) {
            for (Direction facing : DirectionUtil.VALUES) {
                if (!state.m_61138_((Property)AbstractPneumaticCraftBlock.connectionProperty(facing))) continue;
                BlockEntity neighbourBE = ctx.m_43725_().m_7702_(ctx.m_8083_().m_142300_(facing));
                boolean b = neighbourBE != null && neighbourBE.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, facing.m_122424_()).isPresent();
                state = (BlockState)state.m_61124_((Property)AbstractPneumaticCraftBlock.connectionProperty(facing), (Comparable)Boolean.valueOf(b));
            }
            if (this.isRotatable()) {
                Direction f = this.canRotateToTopOrBottom() ? ctx.m_7820_() : ctx.m_8125_();
                state = (BlockState)state.m_61124_((Property)this.directionProperty(), (Comparable)(this.reversePlacementRotation() ? f.m_122424_() : f));
            }
        }
        return state;
    }

    protected boolean reversePlacementRotation() {
        return false;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AbstractPneumaticCraftBlockEntity) {
            AbstractPneumaticCraftBlockEntity pncTE = (AbstractPneumaticCraftBlockEntity)te;
            if (stack.m_41788_()) {
                pncTE.setCustomName(stack.m_41786_());
            }
        }
        if (te instanceof IHeatExchangingTE) {
            IHeatExchangingTE he = (IHeatExchangingTE)te;
            he.initHeatExchangersOnPlacement(world, pos);
        }
    }

    public static BooleanProperty connectionProperty(Direction dir) {
        return CONNECTION_PROPERTIES[dir.m_122411_()];
    }

    DirectionProperty directionProperty() {
        return this.canRotateToTopOrBottom() ? BlockStateProperties.f_61372_ : BlockStateProperties.f_61374_;
    }

    protected Direction getRotation(BlockGetter world, BlockPos pos) {
        return this.getRotation(world.m_8055_(pos));
    }

    public Direction getRotation(BlockState state) {
        return (Direction)state.m_61143_((Property)this.directionProperty());
    }

    protected void setRotation(Level world, BlockPos pos, Direction rotation) {
        this.setRotation(world, pos, rotation, world.m_8055_(pos));
    }

    private void setRotation(Level world, BlockPos pos, Direction rotation, BlockState state) {
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)this.directionProperty(), (Comparable)rotation));
    }

    public boolean isRotatable() {
        return false;
    }

    protected boolean canRotateToTopOrBottom() {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.isRotatable()) {
            builder.m_61104_(new Property[]{this.directionProperty()});
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (this.isRotatable()) {
            state = (BlockState)state.m_61124_((Property)this.directionProperty(), (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)this.directionProperty())));
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return this.isRotatable() ? state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)this.directionProperty()))) : state;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (player != null && player.m_6144_()) {
            BlockEntity te = world.m_7702_(pos);
            boolean preserve = false;
            if (te instanceof AbstractPneumaticCraftBlockEntity) {
                AbstractPneumaticCraftBlockEntity pncBE = (AbstractPneumaticCraftBlockEntity)te;
                preserve = true;
                pncBE.setPreserveStateOnBreak(true);
            }
            if (!player.m_7500_() || preserve) {
                Block.m_49892_((BlockState)world.m_8055_(pos), (LevelAccessor)world, (BlockPos)pos, (BlockEntity)te);
            }
            AbstractPneumaticCraftBlock.removeBlockSneakWrenched(world, pos);
            return true;
        }
        if (this.isRotatable()) {
            BlockState state = world.m_8055_(pos);
            if (!this.rotateCustom(world, pos, state, side)) {
                if (this.rotateForgeWay()) {
                    if (!this.canRotateToTopOrBottom()) {
                        side = Direction.UP;
                    }
                    if (this.getRotation((BlockGetter)world, pos).m_122434_() != side.m_122434_()) {
                        this.setRotation(world, pos, DirectionUtil.rotateAround(this.getRotation((BlockGetter)world, pos), side.m_122434_()));
                    }
                } else {
                    Direction f = this.getRotation((BlockGetter)world, pos);
                    do {
                        f = Direction.m_122376_((int)(f.m_122411_() + 1));
                    } while (!this.canRotateToTopOrBottom() && f.m_122434_() == Direction.Axis.Y);
                    this.setRotation(world, pos, f);
                }
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(AbstractPneumaticCraftBlockEntity::onBlockRotated);
            }
            return true;
        }
        return false;
    }

    protected boolean rotateForgeWay() {
        return true;
    }

    protected boolean rotateCustom(Level world, BlockPos pos, BlockState state, Direction side) {
        return false;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos tilePos) {
        if (!world.m_5776_()) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(pncBE -> pncBE.onNeighborTileUpdate(tilePos));
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.m_5776_()) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(pncBE -> pncBE.onNeighborBlockUpdate(fromPos));
        }
    }

    private int getSavedAir(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        return tag != null && tag.m_128441_("AirAmount") ? tag.m_128451_("AirAmount") : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> curInfo, TooltipFlag flag) {
        EntityBlock eb;
        BlockEntity te;
        AbstractPneumaticCraftBlock subTag;
        if (stack.m_41782_()) {
            int savedAir = this.getSavedAir(stack);
            if (savedAir != 0) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.air", Integer.toString(savedAir)).m_130940_(ChatFormatting.GREEN));
            }
            if ((subTag = stack.m_41737_("BlockEntityTag")) != null && subTag.m_128425_("SavedTanks", 10)) {
                CompoundTag tag = subTag.m_128469_("SavedTanks");
                for (String s : tag.m_128431_()) {
                    CompoundTag tankTag = tag.m_128469_(s);
                    FluidTank tank = new FluidTank(tankTag.m_128451_("Amount"));
                    tank.readFromNBT(tankTag);
                    FluidStack fluidStack = tank.getFluid();
                    if (fluidStack.isEmpty()) continue;
                    curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.fluid", new Object[0]).m_130946_(fluidStack.getAmount() + "mB ").m_7220_(fluidStack.getDisplayName()).m_130940_(ChatFormatting.GREEN));
                }
            }
            this.addExtraInformation(stack, world, curInfo, flag);
        }
        if (ClientUtils.hasShiftDown() && (subTag = this) instanceof EntityBlock && (te = (eb = (EntityBlock)subTag).m_142194_(BlockPos.f_121853_, this.m_49966_())) instanceof AbstractAirHandlingBlockEntity) {
            AbstractAirHandlingBlockEntity pneumatic = (AbstractAirHandlingBlockEntity)te;
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxPressure", Float.valueOf(pneumatic.getDangerPressure())).m_130940_(ChatFormatting.YELLOW));
        }
    }

    protected void addExtraInformation(ItemStack stack, BlockGetter world, List<Component> curInfo, TooltipFlag flag) {
    }

    public boolean m_7278_(BlockState pState) {
        return this instanceof IBlockComparatorSupport;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        int n;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof IComparatorSupport) {
            IComparatorSupport comp = (IComparatorSupport)blockEntity;
            n = comp.getComparatorValue();
        } else {
            n = 0;
        }
        return n;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(pncBE -> {
                NonNullList drops = NonNullList.m_122779_();
                pncBE.getContentsToDrop((NonNullList<ItemStack>)drops);
                drops.forEach(stack -> PneumaticCraftUtils.dropItemOnGround(stack, world, pos));
                if (!pncBE.shouldPreserveStateOnBreak()) {
                    PneumaticRegistry.getInstance().getMiscHelpers().playMachineBreakEffect((BlockEntity)pncBE);
                }
            });
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.m_61138_((Property)AbstractPneumaticCraftBlock.connectionProperty(facing))) {
            BlockEntity ourTE = worldIn.m_7702_(currentPos);
            if (ourTE != null && ourTE.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, facing).isPresent()) {
                BlockEntity te = worldIn.m_7702_(currentPos.m_142300_(facing));
                boolean b = te != null && te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, facing.m_122424_()).isPresent();
                stateIn = (BlockState)stateIn.m_61124_((Property)AbstractPneumaticCraftBlock.connectionProperty(facing), (Comparable)Boolean.valueOf(b));
            } else {
                stateIn = (BlockState)stateIn.m_61124_((Property)AbstractPneumaticCraftBlock.connectionProperty(facing), (Comparable)Boolean.valueOf(false));
            }
            return stateIn;
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return this.m_5939_(state, worldIn, pos, CollisionContext.m_82749_()).m_83281_();
    }

    static void removeBlockSneakWrenched(Level world, BlockPos pos) {
        if (!world.m_5776_()) {
            world.m_7471_(pos, false);
            PneumaticRegistry.getInstance().getMiscHelpers().forceClientShapeRecalculation(world, pos);
        }
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            AbstractPneumaticCraftBlockEntity base;
            ServerPlayer sp = (ServerPlayer)player;
            if (!(player instanceof FakePlayer) && te instanceof AbstractPneumaticCraftBlockEntity && !(base = (AbstractPneumaticCraftBlockEntity)te).shouldPreserveStateOnBreak()) {
                AdvancementTriggers.MACHINE_VANDAL.trigger(sp);
            }
        }
        super.m_6240_(worldIn, player, pos, state, te, stack);
    }
}

