/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class DimensionMatcher
implements IPlayerMatcher {
    private final Set<ResourceLocation> dimensionIds;

    public DimensionMatcher(Set<ResourceLocation> dimensionIds) {
        this.dimensionIds = ImmutableSet.copyOf(dimensionIds);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.dimensionIds.size());
        this.dimensionIds.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
    }

    @Override
    public JsonElement toJson() {
        JsonArray res = new JsonArray();
        this.dimensionIds.forEach(id -> res.add(id.toString()));
        return res;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.dimensionIds.isEmpty()) {
            List<Component> items = this.dimensionIds.stream().map(id -> new TextComponent(id.toString())).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.dimensions", new Object[0]), items);
        }
    }

    @Override
    public boolean test(Player playerEntity) {
        return this.dimensionIds.isEmpty() || this.dimensionIds.contains(playerEntity.f_19853_.m_46472_().m_135782_());
    }

    public static class Factory
    implements IPlayerMatcher.MatcherFactory<DimensionMatcher> {
        @Override
        public DimensionMatcher fromJson(JsonElement json) {
            ObjectOpenHashSet dimensionIds = new ObjectOpenHashSet();
            json.getAsJsonArray().forEach(arg_0 -> Factory.lambda$fromJson$0((Set)dimensionIds, arg_0));
            return new DimensionMatcher((Set<ResourceLocation>)dimensionIds);
        }

        @Override
        public DimensionMatcher fromBytes(FriendlyByteBuf buffer) {
            int n = buffer.m_130242_();
            ObjectOpenHashSet dimensionIds = new ObjectOpenHashSet();
            for (int i = 0; i < n; ++i) {
                dimensionIds.add(buffer.m_130281_());
            }
            return new DimensionMatcher((Set<ResourceLocation>)dimensionIds);
        }

        private static /* synthetic */ void lambda$fromJson$0(Set dimensionIds, JsonElement el) {
            dimensionIds.add(new ResourceLocation(el.getAsString()));
        }
    }
}

