/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.common.ai.NodeProcessorDrone;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticleTrail;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityPathNavigateDrone
extends FlyingPathNavigation
implements IPathNavigator {
    private final DroneEntity droneEntity;
    private boolean forceTeleport;
    private int teleportCounter = -1;
    private BlockPos telPos;
    private static final int TELEPORT_TICKS = 120;
    private int stuckTicks = 0;

    public EntityPathNavigateDrone(DroneEntity droneEntity, Level world) {
        super((Mob)droneEntity, world);
        this.droneEntity = droneEntity;
    }

    public boolean m_5624_(Entity pEntity, double pSpeed) {
        return super.m_5624_(pEntity, pSpeed) || this.isGoingToTeleport();
    }

    public Path m_6570_(Entity entity, int p2) {
        BlockPos pos = new BlockPos(entity.m_20185_(), entity.m_142469_().f_82289_, entity.m_20189_());
        if ((entity instanceof ItemEntity && !this.droneEntity.isBlockValidPathfindBlock(pos) || entity instanceof AbstractMinecart) && this.droneEntity.isBlockValidPathfindBlock(pos.m_7494_())) {
            pos = pos.m_7494_();
        }
        return this.m_7864_(pos, p2);
    }

    void setForceTeleport(boolean forceTeleport) {
        this.forceTeleport = forceTeleport;
    }

    @Nullable
    public Path m_7864_(BlockPos pos, int p2) {
        Node lastPoint;
        Path path;
        if (!this.droneEntity.isBlockValidPathfindBlock(pos)) {
            return null;
        }
        if (this.droneEntity.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) < 0.75) {
            return new Path((List)Lists.newArrayList((Object[])new Node[]{new Node(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())}), pos, true);
        }
        this.telPos = pos;
        if (this.forceTeleport) {
            this.teleportCounter = 0;
            return null;
        }
        this.droneEntity.setStandby(false);
        boolean tallBlockKludge = false;
        BlockPos below = pos.m_7495_();
        VoxelShape shape = this.f_26495_.m_8055_(below).m_60812_((BlockGetter)this.f_26495_, below);
        if (!shape.m_83281_() && shape.m_83215_().f_82292_ > 1.0) {
            path = super.m_7864_(pos, 1);
            tallBlockKludge = true;
        } else {
            path = super.m_7864_(pos, 0);
        }
        if (path != null && (lastPoint = path.m_77395_()) != null && pos.m_123333_((Vec3i)lastPoint.m_77288_()) > (tallBlockKludge ? 1 : 0)) {
            path = null;
        }
        if (path == null && this.teleportationAllowed(pos)) {
            if (this.teleportCounter == -1) {
                this.teleportCounter = 0;
            }
        } else {
            this.teleportCounter = -1;
        }
        return path;
    }

    private boolean teleportationAllowed(BlockPos pos) {
        int max = (Integer)ConfigHelper.common().drones.maxDroneTeleportRange.get();
        return !this.droneEntity.isTeleportRangeLimited() || max == 0 || pos.m_203195_((Position)this.droneEntity.getDronePos(), (double)max);
    }

    @Override
    public boolean isGoingToTeleport() {
        return this.teleportCounter >= 0;
    }

    public boolean m_26571_() {
        return super.m_26571_() && !this.isGoingToTeleport();
    }

    public void m_7638_() {
        ++this.f_26498_;
        if (this.isGoingToTeleport()) {
            if (this.teleportCounter == 0 || this.teleportCounter == 60) {
                this.droneEntity.f_19853_.m_5594_(null, this.droneEntity.m_142538_(), (SoundEvent)ModSounds.HUD_INIT.get(), SoundSource.NEUTRAL, 0.3f, this.teleportCounter == 0 ? 0.7f : 1.0f);
            }
            if (this.teleportCounter < 80) {
                Random rand = this.droneEntity.m_21187_();
                float f = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f1 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                float f2 = (rand.nextFloat() - 0.5f) * 0.02f * (float)this.teleportCounter;
                NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123760_, this.droneEntity.m_20185_(), this.droneEntity.m_20186_(), this.droneEntity.m_20189_(), f, f1, f2), (Entity)this.droneEntity);
            }
            if (++this.teleportCounter > 120) {
                if (this.droneEntity.isBlockValidPathfindBlock(this.telPos)) {
                    this.teleport();
                }
                this.teleportCounter = -1;
                this.m_26536_(null, 0.0);
                this.droneEntity.m_21566_().m_6849_((double)this.telPos.m_123341_(), (double)this.telPos.m_123342_(), (double)this.telPos.m_123343_(), this.droneEntity.getDroneSpeed());
                this.droneEntity.addAirToDrone(-10000);
            }
        } else if (!this.m_26571_()) {
            this.m_7636_();
            if (this.f_26496_ != null && !this.f_26496_.m_77392_()) {
                if ((Integer)ConfigHelper.common().drones.stuckDroneTeleportTicks.get() > 0 && this.f_26494_.m_20184_().m_82556_() < 1.0E-4) {
                    if (this.stuckTicks++ > (Integer)ConfigHelper.common().drones.stuckDroneTeleportTicks.get()) {
                        Vec3 v = this.droneEntity.getDronePos();
                        this.droneEntity.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.stuckBlock", new BlockPos((double)Math.round(v.f_82479_), (double)Math.round(v.f_82480_), (double)Math.round(v.f_82481_)));
                        this.teleportCounter = 0;
                        this.telPos = this.f_26496_.m_77406_();
                        this.stuckTicks = 0;
                    }
                } else {
                    this.stuckTicks = 0;
                }
                if (!this.m_26571_()) {
                    Vec3 vec32 = this.f_26496_.m_77380_((Entity)this.f_26494_);
                    this.f_26494_.m_21566_().m_6849_(vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, this.f_26497_);
                }
            }
        }
    }

    public void teleport() {
        Vec3 dest = Vec3.m_82512_((Vec3i)this.telPos);
        NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticleTrail((ParticleOptions)ParticleTypes.f_123760_, this.droneEntity.m_20185_(), this.droneEntity.m_20186_(), this.droneEntity.m_20189_(), dest.f_82479_, dest.f_82480_, dest.f_82481_), (Entity)this.droneEntity);
        this.droneEntity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        this.droneEntity.m_6034_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
    }

    @Override
    public boolean moveToXYZ(double x, double y, double z) {
        boolean success = this.m_26519_(x, y, z, this.droneEntity.getDroneSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    @Override
    public boolean moveToEntity(Entity entity) {
        boolean success = this.m_5624_(entity, this.droneEntity.getDroneSpeed());
        if (success) {
            this.forceRidingEntityPaths();
        }
        return success;
    }

    public boolean m_26536_(Path pathentityIn, double speedIn) {
        return super.m_26536_(pathentityIn, this.droneEntity.getDroneSpeed());
    }

    private void forceRidingEntityPaths() {
        for (Entity ridingEntity : this.droneEntity.m_20197_()) {
            if (!(ridingEntity instanceof Mob)) continue;
            Mob ridingLiving = (Mob)ridingEntity;
            ridingLiving.m_21573_().m_26536_(this.droneEntity.m_21573_().m_26570_(), this.droneEntity.getDroneSpeed());
        }
    }

    @Override
    public boolean hasNoPath() {
        return this.m_26571_();
    }

    protected PathFinder m_5532_(int r) {
        this.f_26508_ = new NodeProcessorDrone();
        return new PathFinder(this.f_26508_, 1000);
    }

    protected Vec3 m_7475_() {
        return this.droneEntity.getDronePos();
    }

    protected boolean m_7632_() {
        return true;
    }
}

