/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidImport;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAILiquidImport<W extends ProgWidgetInventoryBase>
extends DroneAIImExBase<W> {
    public DroneAILiquidImport(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.emptyTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.emptyTank(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    private boolean shouldVoidExcess() {
        return this.progWidget instanceof ProgWidgetLiquidImport && ((ProgWidgetLiquidImport)this.progWidget).shouldVoidExcess();
    }

    private boolean emptyTank(BlockPos pos, boolean simulate) {
        if (!this.shouldVoidExcess() && this.drone.getFluidTank().getFluidAmount() == this.drone.getFluidTank().getCapacity()) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.fullDroneTank");
            this.abort();
            return false;
        }
        BlockEntity te = this.drone.world().m_7702_(pos);
        if (te != null) {
            Direction side;
            boolean didWork = false;
            Direction[] directionArray = DirectionUtil.VALUES;
            int n = directionArray.length;
            for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(side = directionArray[i]) && (didWork = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).map(handler -> this.tryImportFluid((IFluidHandler)handler, simulate)).orElse(false).booleanValue())); ++i) {
            }
            if (didWork) {
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.emptiedToMax", pos);
        }
        if (!((ProgWidgetInventoryBase)this.progWidget).useCount() || this.getRemainingCount() >= 1000) {
            FluidState state = this.drone.world().m_6425_(pos);
            BlockState blockState = this.drone.world().m_8055_(pos);
            if (state.m_76170_() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(state.m_76152_())) {
                Block block;
                FluidStack stack = new FluidStack(state.m_76152_(), 1000);
                if ((this.shouldVoidExcess() || this.drone.getFluidTank().fill(stack, IFluidHandler.FluidAction.SIMULATE) == 1000) && !simulate && (block = blockState.m_60734_()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    pickup.m_142598_((LevelAccessor)this.drone.world(), pos, blockState);
                    this.decreaseCount(1000);
                    this.drone.getFluidTank().fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean tryImportFluid(IFluidHandler sourceHandler, boolean simulate) {
        FluidStack importedFluid = sourceHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (!importedFluid.isEmpty() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(importedFluid.getFluid())) {
            int filledAmount = this.drone.getFluidTank().fill(importedFluid, IFluidHandler.FluidAction.SIMULATE);
            if (filledAmount > 0) {
                if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                    filledAmount = Math.min(filledAmount, this.getRemainingCount());
                }
                if (!simulate) {
                    this.decreaseCount(this.drone.getFluidTank().fill(sourceHandler.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                }
                return true;
            }
            return this.shouldVoidExcess();
        }
        return false;
    }
}

