/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.util.FakePlayer;

public class DroneAIAttackEntity
extends MeleeAttackGoal {
    private final DroneEntity attacker;
    private final AttackType attackType;
    private final double rangedAttackRange;

    public DroneAIAttackEntity(DroneEntity attacker, double speed, boolean useLongMemory, String filterString) {
        super((PathfinderMob)attacker, speed, useLongMemory);
        this.attacker = attacker;
        this.attackType = AttackType.forDrone(attacker);
        float rangeMult = 1.0f;
        switch (this.attackType) {
            case MINIGUN: {
                ItemStack stack = attacker.getMinigun().getAmmoStack();
                Item item = stack.m_41720_();
                if (!(item instanceof AbstractGunAmmoItem)) break;
                AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
                rangeMult = ammo.getRangeMultiplier(stack);
                break;
            }
            case MISSILE: {
                MicromissilesItem.setEntityFilter(attacker.getInv().getStackInSlot(0), filterString);
                rangeMult = 2.0f;
            }
        }
        this.rangedAttackRange = (float)(16 + Math.min(16, attacker.getUpgrades((PNCUpgrade)((Object)ModUpgrades.RANGE.get())))) * rangeMult;
    }

    public boolean m_8036_() {
        switch (this.attackType) {
            case MINIGUN: {
                if (this.attacker.getSlotForAmmo() >= 0) break;
                this.attacker.getDebugger().addEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noAmmo");
                return false;
            }
            case MISSILE: {
                if (this.isMissileUsable(this.attacker)) break;
                this.attacker.getDebugger().addEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noMissile");
                return false;
            }
        }
        LivingEntity target = this.attacker.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.attacker.getDebugger().addEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noEntityToAttack");
            return false;
        }
        return super.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.attacker.incAttackCount();
        if (this.attackType == AttackType.MELEE && this.attacker.m_5448_() != null && this.attacker.getInv().getSlots() > 1) {
            this.equipBestMeleeWeapon();
        }
    }

    public boolean m_8045_() {
        if (this.attackType != AttackType.MELEE) {
            LivingEntity target = this.attacker.m_5448_();
            if (target == null || !target.m_6084_() || this.attackType == AttackType.MINIGUN && this.attacker.getSlotForAmmo() < 0 || this.attackType == AttackType.MISSILE && !this.isMissileUsable(this.attacker)) {
                return false;
            }
            double dist = this.attacker.m_20275_(target.m_20185_(), target.m_142469_().f_82289_, target.m_20189_());
            if (dist < Math.pow(this.rangedAttackRange, 2.0) && this.attacker.m_21574_().m_148306_((Entity)target)) {
                return true;
            }
        }
        return super.m_8045_();
    }

    public void m_8037_() {
        if (this.attackType != AttackType.MELEE) {
            double dist;
            LivingEntity target = this.attacker.m_5448_();
            if (target != null && (dist = this.attacker.m_20275_(target.m_20185_(), target.m_142469_().f_82289_, target.m_20189_())) < Math.pow(this.rangedAttackRange, 2.0) && this.attacker.m_21574_().m_148306_((Entity)target)) {
                this.attacker.getFakePlayer().m_6034_(this.attacker.m_20185_(), this.attacker.m_20186_(), this.attacker.m_20189_());
                this.attackType.doAttack(this.attacker, target);
                if (dist < Math.pow(this.rangedAttackRange * 0.75, 2.0)) {
                    this.attacker.m_21573_().m_26573_();
                }
            }
        } else {
            super.m_8037_();
        }
    }

    private boolean isMissileUsable(DroneEntity drone) {
        ItemStack stack = drone.getInv().getStackInSlot(0);
        return stack.m_41720_() instanceof MicromissilesItem && stack.m_41773_() < stack.m_41776_();
    }

    private void equipBestMeleeWeapon() {
        int bestSlot = 0;
        double bestDmg = 0.0;
        for (int i = 0; i < this.attacker.getInv().getSlots(); ++i) {
            ItemStack stack = this.attacker.getInv().getStackInSlot(i);
            if (stack.m_41619_()) continue;
            AttributeInstance damage = new AttributeInstance(Attributes.f_22281_, c -> {});
            for (AttributeModifier modifier : stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                damage.m_22118_(modifier);
            }
            float f1 = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)this.attacker.m_5448_().m_6336_());
            if (!(damage.m_22135_() + (double)f1 > bestDmg)) continue;
            bestDmg = damage.m_22135_() + (double)f1;
            bestSlot = i;
        }
        if (bestSlot != 0) {
            ItemStack copy = this.attacker.getInv().getStackInSlot(0).m_41777_();
            this.attacker.getInv().setStackInSlot(0, this.attacker.getInv().getStackInSlot(bestSlot));
            this.attacker.getInv().setStackInSlot(bestSlot, copy);
        }
    }

    private static enum AttackType {
        MELEE,
        MINIGUN,
        MISSILE;


        static AttackType forDrone(DroneEntity drone) {
            if (drone.hasMinigun()) {
                return MINIGUN;
            }
            if (drone.getInv().getStackInSlot(0).m_41720_() instanceof MicromissilesItem) {
                return MISSILE;
            }
            return MELEE;
        }

        public void doAttack(DroneEntity attacker, LivingEntity target) {
            switch (this) {
                case MINIGUN: {
                    attacker.tryFireMinigun(target);
                    break;
                }
                case MISSILE: {
                    FakePlayer fakePlayer = attacker.getFakePlayer();
                    fakePlayer.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                    ItemStack stack = attacker.getInv().getStackInSlot(0);
                    if (!(stack.m_41720_() instanceof MicromissilesItem)) break;
                    fakePlayer.f_8941_.m_6261_((ServerPlayer)fakePlayer, attacker.m_183503_(), stack, InteractionHand.MAIN_HAND);
                }
            }
        }
    }
}

