/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.ProgressBarRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.InputEvent;

public class RenderBlockTarget {
    private static final int SERVER_REQUEST_INTERVAL = 60;
    private static final float STAT_SCALE = 0.02f;
    private final Level world;
    private final BlockPos pos;
    private final int posHash;
    private final IGuiAnimatedStat stat;
    private final Player player;
    private final BlockTrackerClientHandler blockTracker;
    public int ticksExisted = 0;
    private int hackTime;
    private BlockEntity te;
    private int nEntries;
    private boolean refreshSent = false;

    public RenderBlockTarget(Level world, Player player, BlockPos pos, BlockEntity te, BlockTrackerClientHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.posHash = pos.hashCode();
        this.te = te;
        this.blockTracker = blockTracker;
        BlockState state = world.m_8055_(pos);
        ItemStack stack = state.m_60734_().getCloneItemStack(state, Minecraft.m_91087_().f_91077_, (BlockGetter)world, pos, player);
        Component title = stack.m_41619_() ? PneumaticCraftUtils.xlate(world.m_8055_(pos).m_60734_().m_7705_(), new Object[0]) : stack.m_41786_();
        this.stat = new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(stack), 20, -20, HUDHandler.getInstance().getStatOverlayColor(), null, false);
        this.stat.setMinimumContractedDimensions(0, 0);
        this.stat.setMinimumExpandedDimensions(16, 16);
        this.stat.setAutoLineWrap(false);
    }

    public void setTileEntity(BlockEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.nEntries > 0;
    }

    private List<IBlockTrackEntry> getApplicableEntries() {
        return this.world.m_46749_(this.pos) ? BlockTrackHandler.getInstance().getEntriesForCoordinate((BlockGetter)this.world, this.pos, this.te) : Collections.emptyList();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void requestServerUpdate(List<IBlockTrackEntry> applicableTrackEntries) {
        for (IBlockTrackEntry entry : applicableTrackEntries) {
            entry.getServerUpdatePositions(this.te).forEach(p -> NetworkHandler.sendToServer(new PacketDescriptionPacketRequest((BlockPos)p)));
        }
        this.refreshSent = true;
    }

    public void tick() {
        if (this.te != null && this.te.m_58901_()) {
            this.te = null;
        }
        this.stat.tickWidget();
        List<IBlockTrackEntry> applicableTrackEntries = this.getApplicableEntries();
        this.nEntries = applicableTrackEntries.size();
        if (this.isPlayerLookingAtTarget() && (!this.refreshSent || this.world.m_46467_() % 60L == (long)(Math.abs(this.posHash) % 60))) {
            this.requestServerUpdate(applicableTrackEntries);
        }
        if (!this.world.m_46859_(this.pos)) {
            ArrayList<Component> textList = new ArrayList<Component>();
            if (this.ticksExisted > 120) {
                this.stat.closeStat();
                if (applicableTrackEntries.stream().anyMatch(entry -> this.blockTracker.countBlockTrackersOfType((IBlockTrackEntry)entry) <= entry.spamThreshold())) {
                    this.stat.openStat();
                }
                if (this.isPlayerLookingAtTarget()) {
                    this.stat.openStat();
                    this.addBlockTrackInfo(textList, applicableTrackEntries);
                }
            } else if (this.ticksExisted < -30) {
                this.stat.closeStat();
            }
            this.stat.setText(textList);
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackManager.getHackableForBlock((BlockGetter)this.world, this.pos, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        matrixStack.m_85836_();
        double x = (double)this.pos.m_123341_() + 0.5;
        double y = (double)this.pos.m_123342_() + 0.5;
        double z = (double)this.pos.m_123343_() + 0.5;
        matrixStack.m_85837_(x, y, z);
        if (!this.world.m_46859_(this.pos)) {
            this.renderBlockHighlight(matrixStack, buffer, this.world, this.pos, partialTicks);
        }
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks) / 1.2f;
        if (this.ticksExisted > 50 && this.ticksExisted <= 120) {
            ProgressBarRenderer.render3d(matrixStack, buffer, 0.0f, 0.4f, 1.8f, 0.7f, 0.0f, targetAcquireProgress, -788529408, -805241088);
        }
        matrixStack.m_85841_(0.02f, 0.02f, 0.02f);
        if (!this.world.m_46859_(this.pos)) {
            if (this.ticksExisted > 120) {
                if (this.isPlayerLookingAtTarget()) {
                    float mul = ClientUtils.getStatSizeMultiplier(Mth.m_14116_((float)((float)ClientUtils.getClientPlayer().m_20275_(x, y, z))));
                    matrixStack.m_85841_(mul, mul, mul);
                    this.stat.renderStat(matrixStack, buffer, partialTicks);
                }
            } else if (this.ticksExisted > 50) {
                RenderUtils.renderString3d((Component)new TranslatableComponent("pneumaticcraft.entityTracker.info.acquiring"), 0.0f, 0.0f, -3092272, matrixStack, buffer, false, true);
                RenderUtils.renderString3d((Component)new TextComponent((int)targetAcquireProgress + "%"), 37.0f, 24.0f, -3092272, matrixStack, buffer, false, true);
            } else if (this.ticksExisted < -30) {
                matrixStack.m_85841_(1.5f, 1.5f, 1.5f);
                this.stat.renderStat(matrixStack, buffer, partialTicks);
                RenderUtils.renderString3d((Component)new TranslatableComponent("pneumaticcraft.blockTracker.info.lostTarget"), 0.0f, (float)(-this.ticksExisted) / 2.5f, -65536, matrixStack, buffer, false, true);
            }
        }
        matrixStack.m_85849_();
    }

    private void renderBlockHighlight(PoseStack matrixStack, MultiBufferSource buffer, Level world, BlockPos pos, float partialTicks) {
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
        if (shape.m_83281_()) {
            return;
        }
        float progress = ((float)(world.m_46467_() & 0x1FL) + partialTicks) / 32.0f;
        float cycle = Mth.m_14031_((float)((float)((double)progress * Math.PI)));
        float shrink = (shape == Shapes.m_83144_() ? 0.05f : 0.0f) + cycle / 60.0f;
        AABB aabb = shape.m_83215_().m_82406_((double)shrink);
        float alpha = 0.5f;
        if (this.blockTracker.getFocusedPos() != null) {
            alpha = this.blockTracker.getFocusedPos().equals((Object)pos) ? 0.75f : 0.15f;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        RenderType type = RenderUtils.renderFrame(matrixStack, buffer, aabb, 0.015625f, 0.25f, 0.75f, 0.75f, alpha, 0xF000F0, new Direction[0]);
        RenderUtils.finishBuffer(buffer, type);
        matrixStack.m_85849_();
    }

    private boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    private void addBlockTrackInfo(List<Component> textList, List<IBlockTrackEntry> entries) {
        entries.forEach(e -> e.addInformation(this.world, this.pos, this.te, this.isPlayerLookingAtTarget() ? this.blockTracker.getFocusedFace() : null, textList));
    }

    private boolean isPlayerLookingAtTarget() {
        return this.pos.equals((Object)this.blockTracker.getFocusedPos());
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackManager.getHackableForBlock((BlockGetter)this.world, this.pos, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((BlockGetter)this.world, this.pos, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.pos));
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(InputEvent.MouseScrollEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.m_6050_(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
        }
        return false;
    }

    public void updateColor(int color) {
        this.stat.setBackgroundColor(color);
    }

    public Component getTitle() {
        return this.stat.getTitle();
    }
}

