/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.BaseContainerBlockEntityAccess;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.LockCode;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockTrackEntryInventory
implements IBlockTrackEntry {
    public static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.inventories");

    @Override
    public boolean shouldTrackWithThisEntry(BlockGetter world, BlockPos pos, BlockState state, BlockEntity te) {
        if (te instanceof ChestBlockEntity && state.m_61138_((Property)ChestBlock.f_51479_) && state.m_61143_((Property)ChestBlock.f_51479_) == ChestType.RIGHT) {
            return false;
        }
        return te != null && !TrackerBlacklistManager.isInventoryBlacklisted(te) && (te instanceof RandomizableContainerBlockEntity || IBlockTrackEntry.hasCapabilityOnAnyFace((ICapabilityProvider)te, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) && !MinecraftForge.EVENT_BUS.post((Event)new InventoryTrackEvent(te));
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(BlockEntity te) {
        if (te instanceof RandomizableContainerBlockEntity && !IBlockTrackEntry.hasCapabilityOnAnyFace((ICapabilityProvider)te, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (te instanceof ChestBlockEntity && te.m_58900_().m_61143_((Property)ChestBlock.f_51479_) == ChestType.LEFT) {
            Direction dir = ChestBlock.m_51584_((BlockState)te.m_58900_());
            builder.add((Object)te.m_58899_().m_142300_(dir));
        }
        builder.add((Object)te.m_58899_());
        return builder.build();
    }

    @Override
    public int spamThreshold() {
        return 16;
    }

    @Override
    public void addInformation(Level world, BlockPos pos, BlockEntity te, Direction face, List<Component> infoList) {
        if (!BlockTrackEntryInventory.canUnlock(te)) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.locked", new Object[0]).m_130940_(ChatFormatting.ITALIC));
            return;
        }
        try {
            IOHelper.getInventoryForTE(te, face).ifPresent(inventory -> {
                boolean empty = true;
                ItemStack[] inventoryStacks = new ItemStack[inventory.getSlots()];
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack iStack = inventory.getStackInSlot(i);
                    if (!iStack.m_41619_()) {
                        empty = false;
                    }
                    inventoryStacks[i] = iStack;
                }
                if (empty) {
                    infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).m_130940_(ChatFormatting.ITALIC));
                } else {
                    infoList.addAll(PneumaticCraftUtils.summariseItemStacks(new ArrayList<Component>(), inventoryStacks));
                }
            });
        }
        catch (Throwable e) {
            TrackerBlacklistManager.addInventoryTEToBlacklist(te, e);
        }
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }

    private static boolean canUnlock(BlockEntity be) {
        if (be instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity base = (BaseContainerBlockEntity)be;
            LockCode key = ((BaseContainerBlockEntityAccess)base).getLockKey();
            return key.m_19107_(ClientUtils.getClientPlayer().m_21205_());
        }
        return true;
    }
}

