/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RenderSearchItemBlock {
    private final BlockPos pos;
    private final Level world;
    private long lastCheck = 0L;
    private int cachedAmount;

    public RenderSearchItemBlock(Level world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public int getSearchedItemCount() {
        if (this.world.m_46467_() - this.lastCheck >= 20L) {
            this.cachedAmount = 0;
            IOHelper.getInventoryForTE(this.world.m_7702_(this.pos)).ifPresent(handler -> {
                int itemCount = 0;
                Item searchedItem = PneumaticArmorItem.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlot.HEAD));
                if (searchedItem != null) {
                    for (int l = 0; l < handler.getSlots(); ++l) {
                        if (handler.getStackInSlot(l).m_41619_()) continue;
                        itemCount += RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), searchedItem);
                    }
                }
                this.cachedAmount = itemCount;
            });
            this.lastCheck = this.world.m_46467_();
        }
        return this.cachedAmount;
    }

    public static int getSearchedItemCount(ItemStack stack, Item item) {
        int itemCount = 0;
        if (stack.m_41720_() == item) {
            itemCount += stack.m_41613_();
        }
        List<ItemStack> inventoryItems = ItemRegistry.getInstance().getStacksInItem(stack);
        for (ItemStack s : inventoryItems) {
            itemCount += RenderSearchItemBlock.getSearchedItemCount(s, item);
        }
        return itemCount;
    }

    public void renderSearchBlock(PoseStack matrixStack, VertexConsumer builder, int totalCount, float partialTicks) {
        RenderSearchItemBlock.renderSearch(matrixStack, builder, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5, this.getSearchedItemCount(), totalCount, partialTicks);
    }

    public static void renderSearch(PoseStack matrixStack, VertexConsumer builder, double x, double y, double z, int itemCount, int totalCount, float partialTicks) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(x, y, z);
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float ratio = (float)itemCount / (float)totalCount;
        float diff = (1.0f - ratio) / 1.5f;
        float size = 1.0f - diff;
        float f = ((float)(ClientUtils.getClientLevel().m_46467_() & 0x1FL) + partialTicks) / 5.092f;
        float alpha = 0.65f + Mth.m_14031_((float)f) * 0.15f;
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(posMat, -size, size, 0.0f).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(posMat, size, size, 0.0f).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(posMat, size, -size, 0.0f).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(posMat, -size, -size, 0.0f).m_85950_(0.0f, 1.0f, 0.0f, alpha).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        matrixStack.m_85849_();
    }
}

