/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.client.render.ProgWidgetRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderCoordWireframe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RenderDroneAI {
    private final AbstractDroneEntity drone;
    private final List<Pair<RenderCoordWireframe, Integer>> blackListWireframes = new ArrayList<Pair<RenderCoordWireframe, Integer>>();
    private float progress = 0.0f;
    private BlockPos oldPos;
    private BlockPos pos;

    public RenderDroneAI(AbstractDroneEntity drone) {
        this.drone = drone;
        this.tick();
    }

    public void tick() {
        BlockPos lastPos = this.pos;
        this.pos = this.drone.getTargetedBlock();
        if (this.pos != null) {
            if (lastPos == null) {
                this.oldPos = this.pos;
            } else if (!this.pos.equals((Object)lastPos)) {
                this.progress = 0.0f;
                this.oldPos = lastPos;
            }
        } else {
            this.oldPos = null;
        }
        this.progress = Math.min((float)Math.PI, this.progress + 0.1f);
        Iterator<Pair<RenderCoordWireframe, Integer>> iterator = this.blackListWireframes.iterator();
        while (iterator.hasNext()) {
            Pair<RenderCoordWireframe, Integer> wireframe = iterator.next();
            ++((RenderCoordWireframe)wireframe.getKey()).ticksExisted;
            wireframe.setValue((Object)((Integer)wireframe.getValue() - 1));
            if ((Integer)wireframe.getValue() > 0) continue;
            iterator.remove();
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        IProgWidget activeWidget;
        for (Pair<RenderCoordWireframe, Integer> wireframe : this.blackListWireframes) {
            ((RenderCoordWireframe)wireframe.getKey()).render(matrixStack, buffer, partialTicks);
        }
        if (PneumaticArmorItem.isPlayerDebuggingDrone(ClientUtils.getClientPlayer(), this.drone) && (activeWidget = this.getActiveWidget(this.drone)) != null) {
            double z;
            double y;
            double x;
            if (this.pos != null) {
                x = this.getInterpolated(this.pos.m_123341_(), this.oldPos.m_123341_(), partialTicks);
                y = this.getInterpolated(this.pos.m_123342_(), this.oldPos.m_123342_(), partialTicks);
                z = this.getInterpolated(this.pos.m_123343_(), this.oldPos.m_123343_(), partialTicks);
            } else {
                x = Mth.m_14139_((double)partialTicks, (double)this.drone.f_19854_, (double)this.drone.m_20185_());
                y = Mth.m_14139_((double)partialTicks, (double)this.drone.f_19855_, (double)this.drone.m_20186_()) + 0.5;
                z = Mth.m_14139_((double)partialTicks, (double)this.drone.f_19856_, (double)this.drone.m_20189_());
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_(x, y + 0.5, z);
            matrixStack.m_85841_(0.01f, 0.01f, 0.01f);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Minecraft.m_91087_().f_91063_.m_109153_().m_90590_()));
            ProgWidgetRenderer.renderProgWidget3d(matrixStack, buffer, activeWidget);
            matrixStack.m_85849_();
        }
    }

    private IProgWidget getActiveWidget(AbstractDroneEntity droneBase) {
        if (droneBase instanceof DroneEntity) {
            return ((DroneEntity)droneBase).getActiveWidget();
        }
        if (droneBase instanceof ProgrammableControllerEntity) {
            return ((ProgrammableControllerEntity)droneBase).getController().getActiveWidget();
        }
        return null;
    }

    private double getInterpolated(double newPos, double oldPos, float partialTicks) {
        double cosProgress = 0.5 - 0.5 * (double)Mth.m_14089_((float)((float)Math.min(Math.PI, (double)(this.progress + partialTicks * 0.1f))));
        return oldPos + (newPos - oldPos) * cosProgress;
    }

    public void addBlackListEntry(Level world, BlockPos pos) {
        this.blackListWireframes.add((Pair<RenderCoordWireframe, Integer>)new MutablePair((Object)new RenderCoordWireframe(world, pos), (Object)60));
    }
}

