/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.projectile.VortexEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class RenderEntityVortex
extends EntityRenderer<VortexEntity> {
    private static final int CIRCLE_POINTS = 20;
    private static final float TEX_SCALE = 0.07f;
    private static final double RADIUS = 0.5;

    public RenderEntityVortex(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public ResourceLocation getTextureLocation(VortexEntity entity) {
        return Textures.VORTEX_ENTITY;
    }

    public void render(VortexEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (!entity.hasRenderOffsetX()) {
            entity.setRenderOffsetX(this.calculateXoffset());
        }
        matrixStackIn.m_85836_();
        VertexConsumer builder = bufferIn.m_6299_(ModRenderTypes.getTextureRenderColored(this.getTextureLocation(entity)));
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_())));
        float incr = 0.31415927f;
        float angleRads = 0.0f;
        while ((double)angleRads < Math.PI * 2) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5 * (double)Mth.m_14031_((float)angleRads), 0.5 * (double)Mth.m_14089_((float)angleRads), 0.0);
            this.renderGust(matrixStackIn, builder, entity.getRenderOffsetX(), packedLightIn);
            matrixStackIn.m_85849_();
            angleRads += incr;
        }
        matrixStackIn.m_85849_();
    }

    private float calculateXoffset() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        HumanoidArm hs = player.m_5737_();
        if (player.m_21205_().m_41720_() != ModItems.VORTEX_CANNON.get()) {
            hs = hs.m_20828_();
        }
        return hs == HumanoidArm.RIGHT ? -4.0f : 16.0f;
    }

    private void renderGust(PoseStack matrixStackIn, VertexConsumer wr, float xOffset, int packedLightIn) {
        float u1 = 0.0f;
        float u2 = 1.0f;
        float v1 = 0.0f;
        float v2 = 1.0f;
        matrixStackIn.m_85841_(0.07f, 0.07f, 0.07f);
        matrixStackIn.m_85837_((double)xOffset, 0.0, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        Matrix4f posMat = matrixStackIn.m_85850_().m_85861_();
        wr.m_85982_(posMat, -7.0f, -2.0f, -2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u1, v1).m_85969_(packedLightIn).m_5752_();
        wr.m_85982_(posMat, -7.0f, -2.0f, 2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u2, v1).m_85969_(packedLightIn).m_5752_();
        wr.m_85982_(posMat, -7.0f, 2.0f, 2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u2, v2).m_85969_(packedLightIn).m_5752_();
        wr.m_85982_(posMat, -7.0f, 2.0f, -2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u1, v2).m_85969_(packedLightIn).m_5752_();
        wr.m_85982_(posMat, -7.0f, 2.0f, -2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u1, v1).m_85969_(packedLightIn).m_5752_();
        wr.m_85982_(posMat, -7.0f, 2.0f, 2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u2, v1).m_85969_(packedLightIn).m_5752_();
        wr.m_85982_(posMat, -7.0f, -2.0f, 2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u2, v2).m_85969_(packedLightIn).m_5752_();
        wr.m_85982_(posMat, -7.0f, -2.0f, -2.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_7421_(u1, v2).m_85969_(packedLightIn).m_5752_();
    }
}

