/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ProgWidgetRenderer {
    private static final Map<ResourceLocation, Consumer<IProgWidget>> ITEM_RENDERERS = new HashMap<ResourceLocation, Consumer<IProgWidget>>();
    private static final Map<ResourceLocation, BiConsumer<PoseStack, IProgWidget>> EXTRA_RENDERERS = new HashMap<ResourceLocation, BiConsumer<PoseStack, IProgWidget>>();

    public static void renderProgWidget2d(PoseStack matrixStack, IProgWidget progWidget, int alpha) {
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)progWidget.getTexture());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        wr.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        wr.m_85982_(posMat, 0.0f, (float)height, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, v).m_5752_();
        wr.m_85982_(posMat, (float)width, (float)height, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u, v).m_5752_();
        wr.m_85982_(posMat, (float)width, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u, 0.0f).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public static void renderProgWidget2d(PoseStack matrixStack, IProgWidget progWidget) {
        ProgWidgetRenderer.renderProgWidget2d(matrixStack, progWidget, 255);
    }

    public static void renderProgWidget3d(PoseStack matrixStack, MultiBufferSource buffer, IProgWidget progWidget) {
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(progWidget.getTexture()), (posMat, builder) -> {
            builder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, (float)width, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, 0.0f).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, (float)width, (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, 0.0f, (float)height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, v).m_85969_(0xF000F0).m_5752_();
        });
    }

    public static void doExtraRendering2d(PoseStack matrixStack, IProgWidget widget) {
        EXTRA_RENDERERS.getOrDefault(widget.getTypeID(), ProgWidgetRenderer::renderGenericExtras).accept(matrixStack, widget);
    }

    public static void doItemRendering2d(IProgWidget widget) {
        ITEM_RENDERERS.getOrDefault(widget.getTypeID(), w -> {}).accept(widget);
    }

    public static <P extends IProgWidget> void registerExtraRenderer(ProgWidgetType<P> type, BiConsumer<PoseStack, P> consumer) {
        EXTRA_RENDERERS.put(type.getRegistryName(), consumer);
    }

    public static <P extends IProgWidget> void registerItemRenderer(ProgWidgetType<P> type, Consumer<P> consumer) {
        ITEM_RENDERERS.put(type.getRegistryName(), consumer);
    }

    public static void renderGenericExtras(PoseStack matrixStack, IProgWidget progWidget) {
        List<Component> info = progWidget.getExtraStringInfo();
        if (!info.isEmpty()) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            Font fr = Minecraft.m_91087_().f_91062_;
            List<FormattedCharSequence> splittedInfo = GuiUtils.wrapTextComponentList(info, 150, fr);
            for (int i = 0; i < splittedInfo.size(); ++i) {
                int stringWidth = fr.m_92724_(splittedInfo.get(i));
                int startX = progWidget.getWidth() / 2 - stringWidth / 4;
                int n = progWidget.getHeight() / 2;
                Objects.requireNonNull(fr);
                int n2 = n - (9 + 1) * (splittedInfo.size() - 1) / 4;
                Objects.requireNonNull(fr);
                int n3 = n2 + (9 + 1) * i / 2;
                Objects.requireNonNull(fr);
                int startY = n3 - 9 / 4;
                Objects.requireNonNull(fr);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)(startX * 2 - 1), (int)(startY * 2 - 1), (int)(startX * 2 + stringWidth + 1), (int)(startY * 2 + 9 + 1), (int)-1056964609);
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                float f = startX * 2 - 1;
                float f2 = startY * 2 - 1;
                float f3 = stringWidth + 2;
                Objects.requireNonNull(fr);
                GuiUtils.drawOutline(matrixStack, bufferBuilder, f, f2, 0.0f, f3, 9 + 2, 192, 192, 192, 255);
                fr.m_92877_(matrixStack, splittedInfo.get(i), (float)(startX * 2), (float)(startY * 2), -16777216);
            }
            matrixStack.m_85849_();
        }
    }

    public static void renderCraftingItem(ProgWidgetCrafting progWidget) {
        ItemStack recipe = progWidget.getRecipeResult(ClientUtils.getClientLevel());
        if (recipe != null) {
            Minecraft.m_91087_().m_91291_().m_115123_(recipe, 8, progWidget.getHeight() / 2 - 8);
            Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, recipe, 8, progWidget.getHeight() / 2 - 8, Integer.toString(recipe.m_41613_()));
        }
    }

    public static void renderItemFilterItem(ProgWidgetItemFilter progWidget) {
        if (progWidget.getVariable().isEmpty() && !progWidget.getFilter().m_41619_()) {
            Minecraft.m_91087_().m_91291_().m_115123_(progWidget.getFilter(), 10, 2);
            Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, progWidget.getFilter(), 10, 2, "");
        }
    }
}

