/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ModRenderTypes
extends RenderType {
    private static final Function<ResourceLocation, RenderType> TEXTURE_RENDER = Util.m_143827_(rl -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(rl, false, false);
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110671_(RenderStateShard.f_110152_).m_173292_(RenderStateShard.f_173103_).m_110691_(false);
        return ModRenderTypes.m_173215_((String)"texture", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final BiFunction<ResourceLocation, Boolean, RenderType> TEXTURE_RENDER_COLORED = Util.m_143821_((rl, disableDepthTest) -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false, false)).m_110685_(f_110139_).m_173292_(RenderStateShard.f_173103_).m_110671_(RenderStateShard.f_110152_).m_110663_(disableDepthTest != false ? f_110111_ : f_110113_).m_110687_(disableDepthTest != false ? f_110115_ : f_110114_).m_110691_(false);
        return ModRenderTypes.m_173215_((String)"texture_color", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    public static RenderType UNTEXTURED_QUAD_NO_DEPTH = ModRenderTypes.m_173215_((String)"untextured_quad_no_depth", (VertexFormat)DefaultVertexFormat.f_85816_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_(RenderStateShard.f_110147_).m_173292_(RenderStateShard.f_173099_).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(RenderStateShard.f_110152_).m_110663_(f_110111_).m_110687_(f_110115_).m_110691_(false));
    public static final RenderType UNTEXTURED_QUAD = ModRenderTypes.m_173215_((String)"untextured_quad", (VertexFormat)DefaultVertexFormat.f_85816_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_(RenderStateShard.f_110147_).m_173292_(RenderStateShard.f_173099_).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(RenderStateShard.f_110152_).m_110663_(f_110113_).m_110687_(f_110114_).m_110691_(false));
    public static final RenderType BLOCK_FRAME = ModRenderTypes.m_173215_((String)"block_frame", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_(f_110147_).m_173292_(RenderStateShard.f_173104_).m_110685_(f_110139_).m_110661_(f_110110_).m_110663_(f_110111_).m_110687_(f_110115_).m_110691_(false));
    public static final RenderType BLOCK_TRACKER = ModRenderTypes.m_173215_((String)"block_tracker", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110673_(RenderStateShard.LineStateShard.f_110130_).m_110685_(f_110139_).m_173292_(RenderStateShard.f_173104_).m_173290_(f_110147_).m_110661_(f_110110_).m_110671_(f_110153_).m_110663_(f_110111_).m_110687_(f_110115_).m_110691_(false));
    public static final RenderType TARGET_CIRCLE = ModRenderTypes.m_173215_((String)"target_circle", (VertexFormat)DefaultVertexFormat.f_85816_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173099_).m_110685_(f_110139_).m_173290_(f_110147_).m_110661_(f_110110_).m_110671_(f_110152_).m_110663_(f_110111_).m_110687_(f_110115_).m_110691_(false));
    private static final Function<Double, RenderType> LINE_LOOPS = Util.m_143827_(lineWidth -> {
        RenderStateShard.LineStateShard lineState = new RenderStateShard.LineStateShard(OptionalDouble.of(lineWidth));
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_110673_(lineState).m_173292_(RenderStateShard.f_173095_).m_173290_(RenderStateShard.f_110147_).m_110671_(RenderStateShard.f_110153_).m_110685_(f_110139_).m_110663_(f_110111_).m_110687_(f_110115_).m_110661_(f_110110_).m_110691_(false);
        return ModRenderTypes.m_173215_((String)"line_loops", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final BiFunction<Boolean, Boolean, RenderType> BLOCK_HILIGHT_FACE = Util.m_143821_((disableDepthTest, disableWriteMask) -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_110685_(f_110139_).m_173290_(f_110147_).m_110671_(f_110153_).m_110663_(disableDepthTest != false ? f_110111_ : f_110113_).m_110687_(disableWriteMask != false ? f_110115_ : f_110114_).m_173292_(RenderStateShard.f_173104_).m_110691_(false);
        return ModRenderTypes.m_173215_((String)"nav_path_lines", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final BiFunction<Boolean, Boolean, RenderType> BLOCK_HILIGHT_LINE = Util.m_143821_((disableDepthTest, disableWriteMask) -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_110685_(f_110139_).m_173290_(f_110147_).m_110663_(disableDepthTest != false ? f_110111_ : RenderStateShard.f_110113_).m_110661_(f_110110_).m_110671_(f_110153_).m_110687_(disableWriteMask != false ? f_110115_ : RenderStateShard.f_110114_).m_173292_(RenderStateShard.f_173095_).m_110691_(false);
        return ModRenderTypes.m_173215_((String)"block_hilight_line", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    public static final RenderType TRIANGLE_FAN = ModRenderTypes.m_173215_((String)"triangle_fan", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_FAN, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).m_173290_(f_110147_).m_173292_(RenderStateShard.f_173104_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> ARMOR_TRANSLUCENT_NO_CULL = Util.m_143827_(rl -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110669_(f_110119_).m_110691_(true);
        return ModRenderTypes.m_173215_((String)"armor_translucent_no_cull", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });

    public ModRenderTypes(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
        super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
    }

    public static RenderType getTextureRender(ResourceLocation texture) {
        return TEXTURE_RENDER.apply(texture);
    }

    public static RenderType getTextureRenderColored(ResourceLocation texture) {
        return ModRenderTypes.getTextureRenderColored(texture, false);
    }

    public static RenderType getTextureRenderColored(ResourceLocation texture, boolean disableDepthTest) {
        return TEXTURE_RENDER_COLORED.apply(texture, disableDepthTest);
    }

    public static RenderType getLineLoops(double lineWidth) {
        return LINE_LOOPS.apply(lineWidth);
    }

    public static RenderType getBlockHilightFace(boolean disableDepthTest, boolean disableWriteMask) {
        return BLOCK_HILIGHT_FACE.apply(disableDepthTest, disableWriteMask);
    }

    public static RenderType getBlockHilightLine(boolean disableDepthTest, boolean disableWriteMask) {
        return BLOCK_HILIGHT_LINE.apply(disableDepthTest, disableWriteMask);
    }

    public static RenderType getArmorTranslucentNoCull(ResourceLocation rl) {
        return ARMOR_TRANSLUCENT_NO_CULL.apply(rl);
    }
}

